% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network_analysis.R
\name{xina_analysis}
\alias{xina_analysis}
\title{xina_analysis}
\usage{
xina_analysis(clustering_result, ppi_db, is_stringdb = TRUE,
  flag_simplify = TRUE, node_shape = "sphere",
  num_clusters_in_row = 5, img_size = NULL, img_qual = 300)
}
\arguments{
\item{clustering_result}{A list containing XINA clustering results. See \link[XINA]{xina_clustering}}

\item{ppi_db}{STRINGdb object}

\item{is_stringdb}{If it is TRUE (default), XINA will process 'ppi_db' as STRINGdb,
but it is FALSE, XINA will accepts your 'ppi_db' as it is.
You can make your own igraph network using customized PPI information instead of STRINGdb.}

\item{flag_simplify}{If it is TRUE (default), XINA will exclude unconnected proteins}

\item{node_shape}{You can choose node shape. Default is "sphere".  See \link[igraph]{shapes}}

\item{num_clusters_in_row}{The number of clusters in a row on the XINA network plot. Default is 5.}

\item{img_size}{Set the image size. For width=1000 and height=1500, it is img_size=c(1000,1500).}

\item{img_qual}{Set the image resolution. Default is 300.}
}
\value{
A PNG file (XINA_Cluster_Networks.png) displaying PPI network plots of all the clusters
and a list containing XINA network analysis results.
     \tabular{rl}{
      \strong{Item} \tab \strong{Description}\cr
      All_network \tab PPI network of all the input proteins\cr
      Sub_network \tab A list containing PPI networks of each clusters\cr
      Data \tab XINA clustering results. See \link[XINA]{xina_clustering}\cr
      Nodes \tab A list of proteins in each cluster\cr
      Conditions \tab A list of experimental condition of proteins in each cluster\cr
      Titles \tab  A list of plot titles for XINA plotting\cr
      out_dir \tab A directory path storing XINA network analysis results\cr
      is_stringdb \tab False = different PPI DB and TRUE = STRING DB\cr
     }
}
\description{
xina_analysis is to analyze protein-protein interaction(PPI) networks using STRINGdb and igraph R package. This module computes PPI networks within each XINA clusters.
}
\examples{
\dontrun{
# load XINA example data
data(xina_example)

# use the following code for utilizing up-to-date STRING DB
tax_id <- 9606  # for human
# tax_id <- 10090  # for mouse
library(STRINGdb)
library(igraph)
string_db <- STRINGdb$new( version='10', species=tax_id, score_threshold=0, input_directory='' )
string_db
xina_result <- xina_analysis(example_clusters, string_db, flag_simplify=FALSE)

# Run XINA with a protein-protein interaction edgelist
data(HPRD)
net_all <- simplify(graph_from_data_frame(d=hprd_ppi, directed=FALSE),
remove.multiple = FALSE, remove.loops = TRUE)
xina_result <- xina_analysis(example_clusters, net_all, is_stringdb=FALSE, flag_simplify=FALSE)
}

}
