% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstat.R
\name{plotVariogramMap}
\alias{plotVariogramMap}
\title{Plot variogram maps}
\usage{
plotVariogramMap(
  sfe,
  features,
  sample_id = "all",
  plot_np = FALSE,
  ncol = NULL,
  colGeometryName = NULL,
  annotGeometryName = NULL,
  reducedDimName = NULL,
  swap_rownames = NULL,
  name = "variogram_map"
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{features}{Features to plot, must be in rownames of the gene count
matrix, colnames of colData or a colGeometry, colnames of cell embeddings
in \code{reducedDim}, or numeric indices of dimension reduction components.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{plot_np}{Logical, whether to plot the number of pairs in each distance
bin instead of the variance.}

\item{ncol}{Number of columns if facetting.}

\item{colGeometryName}{Name of a \code{colGeometry} \code{sf} data frame
whose numeric columns of interest are to be used to compute the metric. Use
\code{\link{colGeometryNames}} to look up names of the \code{sf} data
frames associated with cells/spots.}

\item{annotGeometryName}{Name of a \code{annotGeometry} of the SFE object, to
annotate the gene expression plot.}

\item{reducedDimName}{Name of a dimension reduction, can be seen in
\code{\link[SingleCellExperiment]{reducedDimNames}}. \code{colGeometryName} and
\code{annotGeometryName} have precedence over \code{reducedDimName}.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labeling plot
elements. If not found in \code{rowData}, then rownames of the gene count
matrix will be used.}

\item{name}{Name under which the correlogram results are stored, which is by
default "sp.correlogram".}
}
\value{
A ggplot object.
}
\description{
Plot variogram maps that show the variogram in all directions in a grid of
distances in x and y coordinates.
}
\examples{
library(SFEData)
sfe <- McKellarMuscleData()
sfe <- colDataUnivariate(sfe, "variogram_map", features = "nCounts",
width = 500, cutoff = 5000)
plotVariogramMap(sfe, "nCounts")

}
\seealso{
plotVariogram
}
\concept{Plot spatial analysis results}
