% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLocalResult.R
\name{plotLocalResult}
\alias{plotLocalResult}
\title{Plot local results}
\usage{
plotLocalResult(
  sfe,
  name,
  features,
  attribute = NULL,
  sample_id = "all",
  colGeometryName = NULL,
  annotGeometryName = NULL,
  rowGeometryName = NULL,
  rowGeometryFeatures = NULL,
  ncol = NULL,
  ncol_sample = NULL,
  annot_aes = list(),
  annot_fixed = list(),
  tx_fixed = list(),
  bbox = NULL,
  tx_file = NULL,
  image_id = NULL,
  channel = NULL,
  maxcell = 5e+05,
  aes_use = c("fill", "color", "shape", "linetype"),
  divergent = FALSE,
  diverge_center = NULL,
  annot_divergent = FALSE,
  annot_diverge_center = NULL,
  size = 0.5,
  shape = 16,
  linewidth = 0,
  linetype = 1,
  alpha = 1,
  color = "black",
  fill = "gray80",
  swap_rownames = NULL,
  scattermore = FALSE,
  pointsize = 0,
  bins = NULL,
  summary_fun = sum,
  hex = FALSE,
  show_axes = FALSE,
  dark = FALSE,
  palette = colorRampPalette(c("black", "white"))(255),
  normalize_channels = FALSE,
  type = name,
  ...
)
}
\arguments{
\item{sfe}{A \code{SpatialFeatureExperiment} object.}

\item{name}{Which local spatial results. Use
\code{\link[SpatialFeatureExperiment]{localResultNames}} to see which types
of results have already been calculated.}

\item{features}{Character vector of vectors. To see which features have the
results of a given type, see
\code{\link[SpatialFeatureExperiment]{localResultFeatures}}.}

\item{attribute}{Which field in the local results of the type and features.
If the result of each feature is a vector, the this argument is ignored.
But if the result is a data frame or a matrix, then this is the column name
of the result, such as "Ii" for local Moran's I. For each local spatial
analysis method, there's a default attribute. See Details. Use
\code{\link[SpatialFeatureExperiment]{localResultAttrs}}.}

\item{sample_id}{Sample(s) in the SFE object whose cells/spots to use. Can be
"all" to compute metric for all samples; the metric is computed separately
for each sample.}

\item{colGeometryName}{Name of a \code{colGeometry} \code{sf} data frame
whose numeric columns of interest are to be used to compute the metric. Use
\code{\link{colGeometryNames}} to look up names of the \code{sf} data
frames associated with cells/spots.}

\item{annotGeometryName}{Name of a \code{annotGeometry} of the SFE object, to
annotate the gene expression plot.}

\item{rowGeometryName}{Name of a \code{rowGeometry} of the SFE object to
plot.}

\item{rowGeometryFeatures}{Which features from \code{rowGeometry} to plot.
Can only be a small number to avoid overplotting. Different features are
distinguished by point shape. By default (\code{NULL}), when
\code{rowGeometryName} is specified, this will be whichever items in
\code{features} that are also in the row names of the SFE object. If
features specified for this argument are not the same as or a subset of
those in argument \code{features}, then the spots of all features specified
here will be plotted, differentiated by point shape.}

\item{ncol}{Number of columns if plotting multiple features. Defaults to
\code{NULL}, which means using the same logic as \code{facet_wrap}, which
is used by \code{patchwork}'s \code{\link{wrap_plots}} by default.}

\item{ncol_sample}{If plotting multiple samples as facets, how many columns
of such facets. This is distinct from \code{ncols}, which is for multiple
features. When plotting multiple features for multiple samples, then the
result is a multi-panel plot each panel of which is a plot for each feature
facetted by samples.}

\item{annot_aes}{A named list of plotting parameters for the annotation sf
data frame. The names are which geom (as in ggplot2, such as color and
fill), and the values are column names in the annotation sf data frame.
Tidyeval is NOT supported.}

\item{annot_fixed}{Similar to \code{annot_aes}, but for fixed aesthetic
settings, such as \code{color = "gray"}. The defaults are the same as the
relevant defaults for this function.}

\item{tx_fixed}{Similar to \code{annot_fixed}, but to specify fixed aesthetic
for transcript spots.}

\item{bbox}{A bounding box to specify a smaller region to plot, useful when
the dataset is large. Can be a named numeric vector with names "xmin",
"xmax", "ymin", and "ymax", in any order. If plotting multiple samples, it
should be a matrix with sample IDs as column names and "xmin", "ymin",
"xmax", and "ymax" as row names. If multiple samples are plotted but
\code{bbox} is a vector rather than a matrix, then the same bounding box
will be used for all samples. You may see points at the edge of the
geometries if the intersection between the bounding box and a geometry
happens to be a point there. If \code{NULL}, then the entire tissue is
plotted.}

\item{tx_file}{File path to GeoParquet file of the transcript spots if you
don't wish to load all transcript spots into the SFE object. See
\code{\link{formatTxSpots}} on generating such a GeoParquet file.}

\item{image_id}{ID of the image to plot behind the geometries. If
\code{NULL}, then not plotting images. Use \code{\link{imgData}} to see
image IDs present. To plot multiple grayscale images as different RGB
channels, use a named vector here, whose names are channel names (r, g, b),
and values are image_ids of the corresponding images. The RGB colorization
may not be colorblind friendly. When plotting multiple samples, it is
assumed that the same image_id is used for each channel across different
samples.}

\item{channel}{Numeric vector indicating which channels in a multi-channel
image to plot. If \code{NULL}, grayscale is plotted if there is 1 channel
and RGB for the first 3 channels. The numeric vector can be named (r, g, b)
to indicate which channel maps to which color. The RGB colorization may not
be colorblind friendly. This argument cannot be specified while
\code{image_id} is a named vector to plot different grayscale images as
different channels.}

\item{maxcell}{Maximum number of pixels to plot in the image. If the image is
larger, it will be resampled so it have less than this number of pixels to
save memory and for faster plotting. We recommend reducing this number when
plotting multiple facets.}

\item{aes_use}{Aesthetic to use for discrete variables. For continuous
variables, it's always "fill" for polygons and point shapes 21-25. For
discrete variables, it can be fill, color, shape, or linetype, whenever
applicable. The specified value will be changed to the applicable
equivalent. For example, if the geometry is point but "linetype" is
specified, then "shaped" will be used instead.}

\item{divergent}{Logical, whether a divergent palette should be used.}

\item{diverge_center}{If \code{divergent = TRUE}, the center from which the
palette should diverge. If \code{NULL}, then not centering.}

\item{annot_divergent}{Just as \code{divergent}, but for the annotGeometry in
case it's different.}

\item{annot_diverge_center}{Just as \code{diverge_center}, but for the
annotGeometry in case it's different.}

\item{size}{Fixed size of points. For points defaults to 0.5. Ignored if
\code{size_by} is specified.}

\item{shape}{Fixed shape of points, ignored if \code{shape_by} is specified
and applicable.}

\item{linewidth}{Width of lines, including outlines of polygons. For
polygons, this defaults to 0, meaning no outlines.}

\item{linetype}{Fixed line type, ignored if \code{linetype_by} is specified
and applicable.}

\item{alpha}{Transparency.}

\item{color}{Fixed color for \code{colGeometry} if \code{color_by} is not
specified or not applicable, or for \code{annotGeometry} if
\code{annot_color_by} is not specified or not applicable.}

\item{fill}{Similar to \code{color}, but for fill.}

\item{swap_rownames}{Column name of \code{rowData(object)} to be used to
identify features instead of \code{rownames(object)} when labeling plot
elements. If not found in \code{rowData}, then rownames of the gene count
matrix will be used.}

\item{scattermore}{Logical, whether to use the \code{scattermore} package to
greatly speed up plotting numerous points. Only used for POINT
\code{colGeometries}. If the geometry is not POINT, then the centroids are
used. Recommended for plotting hundreds of thousands or more cells where
the cell polygons can't be seen when plotted due to the large number of
cells and small plot size such as when plotting multiple panels for
multiple features.}

\item{pointsize}{Radius of rasterized point in \code{scattermore}. Default to
0 for single pixels (fastest).}

\item{bins}{If binning the \code{colGeometry} in space due to large number of
cells or spots, the number of bins, passed to \code{\link{geom_bin2d}} or
\code{\link{geom_hex}}. If \code{NULL} (default), then the
\code{colGeometry} is plotted without binning. If binning, a point geometry
is recommended. If the geometry is not point, then the centroids will be
used.}

\item{summary_fun}{Function to summarize the feature value when the
\code{colGeometry} is binned.}

\item{hex}{Logical, whether to use \code{\link{geom_hex}}. Note that
\code{geom_hex} is broken in \code{ggplot2} version 3.4.0. Please update
\code{ggplot2} if you are getting horizontal stripes when \code{hex =
TRUE}.}

\item{show_axes}{Logical, whether to show axes.}

\item{dark}{Logical, whether to use dark theme. When using dark theme, the
palette will have lighter color represent higher values as if glowing in
the dark. This is intended for plotting gene expression on top of
fluorescent images.}

\item{palette}{Vector of colors to use to color grayscale images.}

\item{normalize_channels}{Logical, whether to normalize each channel of the
image individually. Should be \code{FALSE} for bright field color images
such as H&E but should set to \code{TRUE} for fluorescent images.}

\item{type}{An \code{\link{SFEMethod}} object or a string corresponding to
the name of one of such objects in the environment. If the
\code{localResult} of interest was manually added outside
\code{\link{runUnivariate}} and \code{\link{runBivariate}}, so the method
is not recorded, then the \code{type} argument can be used to specify the
method to properly get the title and labels. By default, this argument is
set to be the same as argument \code{name}. If the method parameters are
recorded, then the \code{type} argument is ignored.}

\item{...}{Other arguments passed to \code{\link{wrap_plots}}.}
}
\value{
A \code{ggplot2} object if plotting one feature. A \code{patchwork}
  object if plotting multiple features.
}
\description{
Plot results of local spatial analyses in space, such as local Getis-Ord Gi*
values.
}
\details{
Many local spatial analyses return a data frame or matrix as the results,
whose columns can be the statistic of interest at each location, its
variance, expected value from permutation, p-value, and etc. The
\code{attribute} argument specifies which column to use when there are
multiple columns. Below are the defaults for each local method supported by
this package what what they mean:

\describe{
\item{\code{localmoran} and \code{localmoran_perm}}{\code{Ii}, local Moran's
I statistic at each location.}
\item{\code{localC_perm}}{\code{localC}, the local Geary C statistic at each
location.}
\item{\code{localG} and \code{localG_perm}}{\code{localG}, the local
Getis-Ord Gi or Gi* statistic. If \code{include_self = TRUE} when
\code{\link{calculateUnivariate}} or \code{\link{runUnivariate}} was called,
then it would be Gi*. Otherwise it's Gi.}
\item{\code{LOSH} and \code{LOSH.mc}}{\code{Hi}, local spatial
heteroscedasticity}
\item{\code{moran.plot}}{\code{wx}, the average of the value of each neighbor
of each location. Moran plot is best plotted as a scatter plot of \code{wx}
vs \code{x}. See \code{\link{moranPlot}}.}
}

Other local methods not listed above return vectors as results. For instance,
\code{localC} returns a vector by default, which is the local Geary's C
statistic.
}
\note{
While this function shares internals with
  \code{\link{plotSpatialFeature}}, there are some important differences. In
  \code{\link{plotSpatialFeature}}, the \code{annotGeometry} is indeed only
  used for annotation and the protagonist is the \code{colGeometry}, since
  it's easy to directly use \code{ggplot2} to plot the data in
  \code{annotGeometry} \code{sf} data frames while overlaying
  \code{annotGeometry} and \code{colGeometry} involves more complicated code.
  In contrast, in this function, local results for \code{annotGeometry} can
  be plotted separately without anything related to \code{colGeometry}. Note
  that when \code{annotGeometry} local results are plotted without
  \code{colGeometry}, the \code{annot_*} arguments are ignored. Use the other
  arguments for aesthetics as if it's for \code{colGeometry}.
}
\examples{
library(SpatialFeatureExperiment)
library(SFEData)
library(scater)
sfe <- McKellarMuscleData("small")
sfe <- sfe[,sfe$in_tissue]
colGraph(sfe, "visium") <- findVisiumGraph(sfe)
feature_use <- rownames(sfe)[1]
sfe <- logNormCounts(sfe)
sfe <- runUnivariate(sfe, "localmoran", feature_use)
# Which types of results are available?
localResultNames(sfe)
# Which features for localmoran?
localResultFeatures(sfe, "localmoran")
# Which columns does the localmoran results have?
localResultAttrs(sfe, "localmoran", feature_use)
plotLocalResult(sfe, "localmoran", feature_use, "Ii",
    colGeometryName = "spotPoly"
)

# For annotGeometry
# Make sure it's type POLYGON
annotGeometry(sfe, "myofiber_simplified") <-
    sf::st_buffer(annotGeometry(sfe, "myofiber_simplified"), 0)
annotGraph(sfe, "poly2nb_myo") <-
    findSpatialNeighbors(sfe,
        type = "myofiber_simplified", MARGIN = 3,
        method = "poly2nb", zero.policy = TRUE
    )
sfe <- annotGeometryUnivariate(sfe, "localmoran",
    features = "area",
    annotGraphName = "poly2nb_myo",
    annotGeometryName = "myofiber_simplified",
    zero.policy = TRUE
)
plotLocalResult(sfe, "localmoran", "area", "Ii",
    annotGeometryName = "myofiber_simplified",
    size = 0.3, color = "cyan"
)
plotLocalResult(sfe, "localmoran", "area", "Z.Ii",
    annotGeometryName = "myofiber_simplified"
)
# don't use annot_* arguments when annotGeometry is plotted without colGeometry
}
\concept{Plot spatial analysis results}
