% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstat.R
\name{plotCrossVariogramMap}
\alias{plotCrossVariogramMap}
\title{Plot cross variogram map}
\usage{
plotCrossVariogramMap(res, plot_np = FALSE)
}
\arguments{
\item{res}{Cross variogram results for one sample, from
\code{\link{calculateBivariate}}. Global bivariate results are not stored
in the SFE object.}

\item{plot_np}{Logical, whether to plot the number of pairs in each distance
bin instead of the variance.}
}
\value{
A ggplot object.
}
\description{
Equivalent to \code{gstat::plot.gstatVariogram}, but using ggplot2 to be more
customizable.
}
\examples{
library(SFEData)
library(scater)
sfe <- McKellarMuscleData()
sfe <- sfe[,sfe$in_tissue]
sfe <- logNormCounts(sfe)

res <- calculateBivariate(sfe, type = "cross_variogram_map",
feature1 = c("Myh1", "Myh2", "Csrp3"), swap_rownames = "symbol",
width = 500, cutoff = 2000)
plotCrossVariogramMap(res)

}
\seealso{
plotCrossVariogram
}
\concept{Plot spatial analysis results}
