% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxParquet-class.R
\docType{class}
\name{TENxParquet-class}
\alias{TENxParquet-class}
\alias{.TENxParquet}
\alias{TENxParquet}
\alias{TENxMappingParquet-class}
\alias{.TENxMappingParquet}
\alias{TENxMappingParquet}
\alias{import,TENxMappingParquet,ANY,ANY-method}
\title{Represent and import Parquet data from 10X Genomics}
\usage{
TENxParquet(resource, type = c("spatial", "mapping"))

TENxMappingParquet(resource, colnames = .MAPPING_POS_COLS)

\S4method{import}{TENxMappingParquet,ANY,ANY}(con, format, text, ...)
}
\arguments{
\item{resource}{character(1) The path to the file}

\item{type}{\code{character(1)} A scalar specifying the type of Parquet file to
import, either "spatial" or "mapping". If not provided, the type is
determined by whether or not there is a "mapping" keyword in the file name.}

\item{colnames}{\code{character()} A vector specifying the column names of the
Parquet, defaults to all columns in the dataset.}

\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[BiocIO:BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{format}{The format of the output. If missing and \code{con} is a
file name, the format is derived from the file extension. This argument is
unnecessary when \code{con} is a derivative of \link[BiocIO:BiocFile-class]{BiocFile}.}

\item{text}{If \code{con} is missing, this can be a character vector directly
providing the string data to import.}

\item{...}{Additional inputs to the low level class generator functions}
}
\value{
\code{TENxParquet()}: An object of class \link{TENxSpatialParquet} or
\link{TENxMappingParquet}

\code{TENxMappingParquet()}: An object of class \link{TENxMappingParquet}
}
\description{
\code{TENxParquet} is a virtual class to represent and import Parquet
files from 10X Genomics. It is a composed class of \link[TENxIO:TENxFile]{TENxIO::TENxFile}.

\code{TENxSpatialParquet} is a class to represent and import spatial
Parquet files from 10X Genomics. It is a composed class of
\link[TENxIO:TENxFile]{TENxIO::TENxFile}.
}
\details{
Typically, the user will not create an object of this class directly
but rather use the \code{TENxParquet} constructor function to create an object
of either \link{TENxSpatialParquet} or \link{TENxMappingParquet} class in the
background.
}
\examples{
sample_dir <- system.file(
    file.path("extdata", "binned_outputs", "square_002um", "spatial"),
    package = "VisiumIO"
)
spatial_dir <- Filter(
    function(x) endsWith(x, "spatial"), list.dirs(sample_dir)
)
parquetres <- file.path(spatial_dir, "tissue_positions.parquet")
TENxParquet(parquetres)
parq_file <- system.file(
    "extdata", "barcode_mappings.parquet",
    package = "VisiumIO", mustWork = TRUE
)
TENxMappingParquet(parq_file)
}
