% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TENxVisium-class.R
\docType{class}
\name{TENxVisium-class}
\alias{TENxVisium-class}
\alias{.TENxVisium}
\alias{TENxVisium}
\alias{import,TENxVisium,ANY,ANY-method}
\title{A class to represent and import a single Visium Sample}
\usage{
TENxVisium(
  resources,
  spatialResource,
  spacerangerOut,
  sample_id = "sample01",
  processing = c("filtered", "raw"),
  format = c("mtx", "h5"),
  images = c("lowres", "hires", "detected", "aligned", "cytassist"),
  jsonFile = .SCALE_JSON_FILE,
  tissuePattern = "tissue_positions.*\\\\.csv",
  spatialCoordsNames = c("pxl_col_in_fullres", "pxl_row_in_fullres"),
  ...
)

\S4method{import}{TENxVisium,ANY,ANY}(con, format, text, ...)
}
\arguments{
\item{resources}{A \link[TENxIO:TENxFileList-class]{TENxFileList} object or a
file path to the tarball containing the matrix / assay data resources.}

\item{spatialResource}{A \link[=TENxSpatialList-class]{TENxSpatialList}
object or a file path to the tarball containing the spatial data.}

\item{spacerangerOut}{\code{character(1)} A single string specifying the path to
the directory where the output of \verb{spaceranger count} is located; typically
(but not necessarily), this is the \code{outs} directory. The directory must
contain the \verb{(processing)_feature_bc_matrix} and \code{spatial} sub directories.}

\item{sample_id}{\code{character(1)} A single string specifying the sample ID.}

\item{processing}{\code{character(1)} A single string indicating the processing
folder available e.g., "filtered_feature_barcode_matrix" in the
\code{spacerangerOut} folder. It can be either "filtered" or "raw" (default
"filtered"). Only used when \code{spacerangerOut} is specified.}

\item{format}{The format of the output. If missing and \code{con} is a
file name, the format is derived from the file extension. This argument is
unnecessary when \code{con} is a derivative of \link[BiocIO:BiocFile-class]{BiocFile}.}

\item{images}{\code{character()} A vector specifying the images to be imported;
can be one or multiple of "lowres", "hires", "detected", "aligned".}

\item{jsonFile}{\code{character(1)} A single string specifying the name of the
JSON file containing the scale factors.}

\item{tissuePattern}{\code{character(1)} A single string specifying the pattern
to match the tissue positions file.}

\item{spatialCoordsNames}{\code{character()} A vector of strings specifying the
names of the columns in the spatial data containing the spatial coordinates.}

\item{...}{In the constructor, additional arguments passed to
\link[TENxIO:TENxFileList-class]{TENxFileList}; otherwise, not used.}

\item{con}{The connection from which data is loaded or to which data is
saved. If this is a \code{character} vector, it is assumed to be a file name and
a corresponding file connection is created and then closed after exporting
the object. If it is a \link[BiocIO:BiocFile-class]{BiocFile} derivative, the
data is loaded from or saved to the underlying resource. If missing, the
function will return the output as a character vector, rather than writing
to a connection.}

\item{text}{If \code{con} is missing, this can be a character vector directly
providing the string data to import.}
}
\value{
A \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment}
object
}
\description{
This class is a composed class of
\link[TENxIO:TENxFileList-class]{TENxFileList} which can contain a list of
\link[TENxIO:TENxFile-class]{TENxFile} objects and a \link{TENxSpatialList} object.
It is meant to handle a single Visium sample from 10X Genomics.
}
\details{
Typically, the user will not create an object of this class directly
but rather use \link{TENxVisiumList} constructor function for multiple samples.
Note that the \code{images}, \code{jsonFile}, \code{tissuePattern}, and
\code{spatialCoordsNames} arguments are only considered when the
\code{spacerangerOut} argument or both the \code{resources} and \code{spatialResource}
arguments are paths to files.
}
\section{Functions}{
\itemize{
\item \code{import(con = TENxVisium, format = ANY, text = ANY)}: Import Visium data

}}
\section{Slots}{

\describe{
\item{\code{resources}}{A \link[TENxIO:TENxFileList-class]{TENxFileList} or
\link[TENxIO:TENxH5-class]{TENxH5} object containing the Visium data.}

\item{\code{spatialList}}{A \link{TENxSpatialList} object containing the spatial}

\item{\code{coordNames}}{\code{character()} A vector specifying the names
of the columns in the spatial data containing the spatial coordinates.}

\item{\code{sampleId}}{\code{character(1)} A scalar specifying the sample identifier.}
}}

\examples{

outs_dir <- system.file(
    file.path("extdata", "10xVisium", "section1", "outs"),
    package = "VisiumIO"
)

## using spacerangerOut folder
tv <- TENxVisium(
    spacerangerOut = outs_dir, processing = "raw", images = "lowres"
)

import(tv)

## with TENxFileList spacerangerOut input
tvfl <- TENxVisium(
    spacerangerOut = TENxFileList(outs_dir),
    format = "mtx",
    processing = "raw",
    images = "lowres"
)

import(tvfl)

## check metadata of the object
import(tvfl) |>
    metadata() |>
    lapply(names)

## importing h5 format
tvfl <- TENxVisium(
    spacerangerOut = outs_dir,
    format = "h5",
    processing = "raw",
    images = "lowres"
)

import(tvfl)

rffolder <- file.path(outs_dir, "raw_feature_bc_matrix")
## using resources and spatialResource inputs
tvfl <- TENxVisium(
    resources = rffolder,
    spatialResource = file.path(dirname(rffolder), "spatial"),
    format = "mtx",
    processing = "raw",
    images = "lowres"
)

import(tvfl)

}
\seealso{
\url{https://support.10xgenomics.com/spatial-gene-expression/software/pipelines/latest/output/overview}
}
