% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters_cor.R
\name{clusters_cor}
\alias{clusters_cor}
\alias{clusters_cor,list,character-method}
\title{Compute distance matrix between dendrograms partitions.}
\usage{
clusters_cor(clusters, method = "adjusted.rand")

\S4method{clusters_cor}{list,character}(clusters, method = "adjusted.rand")
}
\arguments{
\item{clusters}{a \code{list} of \code{\link{GO_clusters-class}} objects,
from \code{\link{GOterms_heatmap}} or \code{\link{GOclusters_heatmap}}, named as \code{character}.}

\item{method}{available methods  ("vi", "nmi", "split.join", "rand", or "adjusted.rand") from \pkg{igraph} package \code{\link[igraph]{compare}} function.}
}
\value{
a distance or a correlation matrix.
}
\description{
Build a distance or correlation matrix between partitions from dendrograms.
}
\examples{
# load example object
data(
    myGOs,
    package="ViSEAGO"
)

\dontrun{
# compute Semantic Similarity (SS)
myGOs<-ViSEAGO::compute_SS_distances(
    myGOs,
    distance=c("Resnik","Lin","Rel","Jiang","Wang")
)

# Resnik distance GO terms heatmap
Resnik_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Resnik",
            aggreg.method="ward.D2"
        ),
        cut=list(
            dynamic=list(
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)

# Lin distance GO terms heatmap
Lin_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Lin",
            aggreg.method="ward.D2"
        ),
        cut=list(
            dynamic=list(
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)

# Resnik distance GO terms heatmap
Rel_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Rel",
            aggreg.method="ward.D2"
        ),
        cut=list(
            dynamic=list(
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)

# Resnik distance GO terms heatmap
Jiang_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Jiang",
            aggreg.method="ward.D2"
        ),
        cut=list(
            dynamic=list(
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)

# Resnik distance GO terms heatmap
Wang_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Wang",
            aggreg.method="ward.D2"
        ),
        cut=list(
            dynamic=list(
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)
}
# clusters to compare
clusters<-list(
    Resnik="Resnik_clusters_wardD2",
    Lin="Lin_clusters_wardD2",
    Rel="Rel_clusters_wardD2",
    Jiang="Jiang_clusters_wardD2",
    Wang="Wang_clusters_wardD2"
)

\dontrun{
# global dendrogram clustering correlation
clust_cor<-ViSEAGO::clusters_cor(
    clusters,
    method="adjusted.rand"
)
}
}
\references{
Csardi G, Nepusz T: The igraph software package for complex network research, InterJournal, Complex Systems 1695. 2006. http://igraph.org.
}
\seealso{
Other GO_clusters: 
\code{\link{GO_clusters-class}},
\code{\link{GOclusters_heatmap}()},
\code{\link{compare_clusters}()},
\code{\link{show_heatmap}()},
\code{\link{show_table}()}
}
\concept{GO_clusters}
