% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GOterms_heatmap.R
\name{GOterms_heatmap}
\alias{GOterms_heatmap}
\alias{GOterms_heatmap,GO_SS-method}
\title{Build a clustering heatmap on GO terms.}
\usage{
GOterms_heatmap(
  myGOs,
  showIC = TRUE,
  showGOlabels = TRUE,
  heatmap_colors = c("#ffffff", "#99000D"),
  GO.tree = list(tree = list(distance = "Wang", aggreg.method = "ward.D2", rotate =
    NULL), cut = list(dynamic = list(pamStage = TRUE, pamRespectsDendro = TRUE, deepSplit
    = 2, minClusterSize = 2))),
  samples.tree = NULL
)

\S4method{GOterms_heatmap}{GO_SS}(
  myGOs,
  showIC = TRUE,
  showGOlabels = TRUE,
  heatmap_colors = c("#ffffff", "#99000D"),
  GO.tree = list(tree = list(distance = "Wang", aggreg.method = "ward.D2", rotate =
    NULL), cut = list(dynamic = list(pamStage = TRUE, pamRespectsDendro = TRUE, deepSplit
    = 2, minClusterSize = 2))),
  samples.tree = NULL
)
}
\arguments{
\item{myGOs}{a \code{\link{GO_SS-class}} object from \code{\link{compute_SS_distances}}.}

\item{showIC}{\code{logical} (default to TRUE) to display the GO terms Information Content (IC) side bar.}

\item{showGOlabels}{\code{logical} (default to TRUE) to display the GO terms ticks on y axis.}

\item{heatmap_colors}{pvalues color range with white to Sangria collors by default (c("#ffffff","#99000D")).}

\item{GO.tree}{a named \code{list} of parameters to build and cut the GO terms \code{dendrogram}.
 \describe{
     \item{tree (a named \code{list} with:)}{
         \describe{
             \item{distance ("Wang" by default)}{distance computed from the semantic similarity which could be
              IC-based ("Resnik", "Rel", "Lin", or "Jiang") or graph-based ("Wang").
             }
              \item{aggreg.method ("ward.D2" by default)}{aggregation method criteria from \code{\link[stats]{hclust}} ("ward.D",
              "ward.D2", "single", "complete", "average", "mcquitty", "median", or "centroid") to build a \code{dendrogram}.}
             \item{rotate}{sort the branches of the tree based on a vector - eithor of labels order or the labels in their new order}
         }
     }
     \item{cut (a named \code{list} with:)}{
         \describe{
             \item{static (default to NULL)}{a \code{numeric} value that is the height (between 0 and 1),
             or the number of clusters (value > 1) to cut the \code{dendrogram}.
             }
              \item{dynamic (a named \code{list} which only contains \code{\link[dynamicTreeCut]{cutreeDynamic}}
              options values below)
              }{
                \describe{
                    \item{pamStage (default to TRUE)}{second (PAM-like) stage will be performed.}
                    \item{pamRespectsDendro (default to TRUE)}{PAM stage will respect the dendrogram in the sense that objects
                     and small clusters will only be assigned to clusters that belong to the same branch that the objects or small
                     clusters being assigned belong to.}
                    \item{deepSplit (default to 2)}{provides a rough control over sensitivity for cluster splitting (range 0 to 4).
                      The higher the value (or if TRUE), the more and smaller clusters will be produced.}
                    \item{minClusterSize (default to 2)}{minimum cluster size.}
                }
             }
         }
     }
}}

\item{samples.tree}{a named \code{list} of parameters to build and cut the samples \code{dendrogram} (default to NULL).
 \describe{
     \item{tree (a named \code{list} with:)}{
         \describe{
             \item{distance ("pearson" by default)}{distance computed that could be correlation ("abs.pearson","pearson", "kendall", or "spearman"),
             or \code{dist} method (euclidean", "maximum", "manhattan", "canberra", "binary", or "minkowski).}
              \item{aggreg.method ("average" by default)}{same options than for \code{GO.tree} argument}
         }
     }
     \item{cut}{same options than for \code{GO.tree} argument.}
}}
}
\value{
a \code{\link{GO_clusters-class}} object.
}
\description{
This method computes a clustering heatmap based on GO terms semantic similarity.
}
\details{
This method computes a clustering heatmap based on GO terms semantic similarity (computed with \code{\link{compute_SS_distances}}).\cr
The dendrogram produced could be cutted in static or dynamic mode.\cr
 \enumerate{
  \item build dendrograms on  GO terms and optionally on samples.
  \item cut in static or dynamic mode and color the dendrogram branchs.
  \item build an interactive clustering heatmap based on \code{\link[heatmaply]{heatmaply}}.
 }
}
\examples{
# load data example
utils::data(
    myGOs,
    package="ViSEAGO"
)
\dontrun{
# compute GO terms Semantic Similarity distances
myGOs<-ViSEAGO::compute_SS_distances(
   myGOs,
   distance="Wang"
)

# GOtermsHeatmap with default parameters
Wang_clusters_wardD2<-ViSEAGO::GOterms_heatmap(
    myGOs,
    showIC=TRUE,
    showGOlabels=TRUE,
    GO.tree=list(
        tree=list(
            distance="Wang",
            aggreg.method="ward.D2",
            rotate=NULL
        ),
        cut=list(
            dynamic=list(
                pamStage=TRUE,
                pamRespectsDendro=TRUE,
                deepSplit=2,
                minClusterSize =2
            )
        )
    ),
    samples.tree=NULL
)
}
}
\references{
Matt Dowle and Arun Srinivasan (2017). data.table: Extension of `data.frame`. R package version 1.10.4. https://CRAN.R-project.org/package=data.table.

Tal Galili (2015). dendextend: an R package for visualizing, adjusting, and comparing trees of hierarchical clustering.
Bioinformatics. DOI:10.1093/bioinformatics/btv428.

Tal Galili (2017). heatmaply: Interactive Cluster Heat Maps Using 'plotly'.
R package version 0.9.1. https://CRAN.R-project.org/package=heatmaply.

Peter Langfelder, Bin Zhang and with contributions from Steve Horvath (2016). dynamicTreeCut: Methods for Detection of Clusters
in Hierarchical Clustering Dendrograms. R package version 1.63-1. https://CRAN.R-project.org/package=dynamicTreeCut.

Erich Neuwirth (2014). RColorBrewer: ColorBrewer Palettes. R package version 1.1-2. https://CRAN.R-project.org/package=RColorBrewer.

Carson Sievert, Chris Parmer, Toby Hocking, Scott Chamberlain, Karthik Ram, Marianne Corvellec and Pedro Despouy (2017).
plotly: Create Interactive Web Graphics via 'plotly.js'. R package version 4.6.0. https://CRAN.R-project.org/package=plotly.

Hadley Wickham (2016). scales: Scale Functions for Visualization. R package version 0.4.1. https://CRAN.R-project.org/package=scales.

H. Wickham. ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York, 2009.
}
\seealso{
Other GO_terms: 
\code{\link{GOcount}()},
\code{\link{annotate}()},
\code{\link{create_topGOdata}()},
\code{\link{gene2GO-class}},
\code{\link{merge_enrich_terms}()},
\code{\link{runfgsea}()}

Other visualization: 
\code{\link{GOclusters_heatmap}()},
\code{\link{GOcount}()},
\code{\link{Upset}()},
\code{\link{available_organisms}()},
\code{\link{overLapper}()},
\code{\link{show_heatmap}()},
\code{\link{show_table}()}
}
\concept{GO_terms}
\concept{semantic_similiarity}
\concept{visualization}
