% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{vennStats}
\alias{vennStats}
\title{Perform statistical tests on set intersections}
\usage{
vennStats(
  object,
  universe = NULL,
  method = c("hypergeometric", "permutation"),
  nperm = 1000,
  adjust.method = "BH",
  include_singles = FALSE
)
}
\arguments{
\item{object}{A Venn object}

\item{universe}{Size of the universe for hypergeometric test. Default: NULL (will use the union of all sets)}

\item{method}{Statistical method to use: "hypergeometric" or "permutation". Default: "hypergeometric"}

\item{nperm}{Number of permutations if method="permutation". Default: 1000}

\item{adjust.method}{Method for multiple testing correction. Default: "BH"}

\item{include_singles}{Logical: include tests for single sets? Default: FALSE}
}
\value{
A data.frame with statistical test results
}
\description{
Performs statistical tests to evaluate the significance of set intersections
}
\examples{
A <- sample(1:1000, 100, replace = FALSE)
B <- sample(1:1000, 150, replace = FALSE)
C <- sample(1:1000, 120, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))
stats <- vennStats(res)
}
\author{
Kai Guo
}
