% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{saveVenn}
\alias{saveVenn}
\title{Save a Venn object to a file}
\usage{
saveVenn(object, file)
}
\arguments{
\item{object}{A Venn object}

\item{file}{File name to save to}
}
\value{
The file name (invisibly)
}
\description{
Saves a Venn object to an RDS file for later use
}
\examples{
\dontrun{
# Create a Venn object
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
res <- venndetail(list(A = A, B = B))

# Save to a file
saveVenn(res, "my_venn.rds")
}
}
\author{
Kai Guo
}
