% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{newVenn}
\alias{newVenn}
\title{Create a new Venn object}
\usage{
newVenn(
  input,
  raw,
  sep = "_",
  GroupNames,
  result,
  detail,
  wide,
  metadata = list()
)
}
\arguments{
\item{input}{A list of input sets}

\item{raw}{A named vector with counts}

\item{sep}{The separator character}

\item{GroupNames}{Names of the input groups}

\item{result}{The result data.frame}

\item{detail}{The detail vector}

\item{wide}{The wide-format data.frame}

\item{metadata}{Additional metadata (optional)}
}
\value{
A new Venn object
}
\description{
Constructor function for creating Venn objects with validation
}
\examples{
\dontrun{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
raw <- c(A = 40, B = 60)
groups <- c("A", "B")
# Create a new Venn object manually (normally done by venndetail function)
venn_obj <- newVenn(input = list(A = A, B = B), raw = raw,
                    GroupNames = groups, ...)
}
}
\author{
Kai Guo
}
