% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-extraction.R
\name{getSet,Venn-method}
\alias{getSet,Venn-method}
\title{Extract specific subsets from a Venn object}
\usage{
\S4method{getSet}{Venn}(object, subset = NULL, min = 0, wide = FALSE)
}
\arguments{
\item{object}{A Venn object}

\item{subset}{Character vector of subset names to extract}

\item{min}{Minimum number of sets an element must be in}

\item{wide}{Logical: return results in wide format?}
}
\value{
A data.frame with elements from the specified subsets
}
\description{
Extracts elements from specified subsets
}
\examples{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))
# Get elements unique to set A
unique_to_A <- getSet(res, "A")
# Get elements shared by all sets
shared <- getSet(res, "Shared")
}
