% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/dplot.R
\name{dplot}
\alias{dplot}
\title{Create a bar plot of subset counts}
\usage{
dplot(
  object,
  order = FALSE,
  textsize = 5,
  color = NULL,
  theme = ggplot2::theme_light(),
  title = NULL,
  xlabel = NULL,
  ylabel = NULL
)

\S4method{dplot}{Venn}(object, order = FALSE, textsize = 5)
}
\arguments{
\item{object}{Venn object}

\item{order}{Boolean indicating whether to sort the bar (default: FALSE).}

\item{textsize}{Numeric vector giving the text size above the bar.}

\item{color}{Optional vector of colors for the bars}

\item{theme}{The ggplot2 theme to use. Default: theme_light}

\item{title}{Optional plot title}

\item{xlabel}{Optional x-axis label}

\item{ylabel}{Optional y-axis label}
}
\value{
A ggplot2 object
}
\description{
Creates a bar plot showing counts for each subset
}
\examples{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))
dplot(res, order = TRUE, textsize = 3)
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))
dplot(res, order = TRUE, textsize = 3)
}
\author{
Kai Guo
}
