% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{addVDJtoSCE}
\alias{addVDJtoSCE}
\alias{addVDJtoSCE,SplitDataFrameList,SingleCellExperiment-method}
\alias{addVDJtoSCE,character,SingleCellExperiment-method}
\title{Add 10X CellRanger V(D)J data to SingleCellExperiment}
\usage{
addVDJtoSCE(samples, sce, ...)

\S4method{addVDJtoSCE}{SplitDataFrameList,SingleCellExperiment}(samples, sce, sample.names = NULL, barcode = "Barcode")

\S4method{addVDJtoSCE}{character,SingleCellExperiment}(samples, sce, sample.names = names(samples), barcode = "Barcode")
}
\arguments{
\item{samples}{A character vector containing one or more directory names,
each corresponding to a 10X sample. Each directory should contain a file
named \code{filtered_contig_annotations.csv}. Alternatively, a
\code{SplitDataFrameList}, the output of \code{\link{readVDJcontigs}}.}

\item{sce}{A \code{SingleCellExperiment} object.}

\item{...}{additional arguments.}

\item{sample.names}{A character vector of length equal to \code{samples}
containing the sample names to store in the output object. If \code{NULL}
and \code{samples} is a character vector, the \code{basename}s of each
directory will be used.}

\item{barcode}{The column name from the \code{colData} of \code{sce}
containing cell barcodes. These should match the barcodes in the V(D)J data
(see Details). Alternatively, a vector of cell barcodes of length equal to
\code{ncol(sce)}.}
}
\value{
A \code{\link[SingleCellExperiment]{SingleCellExperiment}} object
with an element named \code{"contigs"} added to the \code{colData},
representing the V(D)J data.
}
\description{
Matches CellRanger V(D)J data to paired data in an existing
\code{\link[SingleCellExperiment]{SingleCellExperiment}} object.
}
\details{
Matching cell barcodes between data objects can cause problems,
because different methods have different ways of ensuring barcodes are
unique across all samples. This function and \code{\link{readVDJcontigs}}
follow the naming conventions of \code{\link[DropletUtils]{read10xCounts}},
where the sample index (in the \code{samples} vector) is appended to each
cell barcode, to ensure that each barcode is unique, across all samples. If
\code{sce} was created by a different method, such as conversion from a
\code{Seurat} object, you may need to check the barcode naming convention.
}
\examples{
# load example V(D)J data
data('contigs')
# make SCE object with matching barcodes and sample IDs
ncells <- 24
u <- matrix(rpois(1000 * ncells, 5), ncol = ncells)
barcodes <- vapply(contigs[,'barcode'], function(x){ x[1] }, 'A')
samples <- vapply(contigs[,'sample'], function(x){ x[1] }, 'A')
sce <- SingleCellExperiment::SingleCellExperiment(assays = list(counts = u),
                            colData = data.frame(Barcode = barcodes,
                                                 sample = samples))
sce <- addVDJtoSCE(contigs, sce)
sce$contigs

}
