% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{makeWindowFragments}
\alias{makeWindowFragments}
\title{Make windows merging restriction fragments}
\usage{
makeWindowFragments(input, n_frags = 8, sliding = 1)
}
\arguments{
\item{input}{Input object containing the restriction fragments. Should be 
class UMI4C (rowRanges will be extracted) or class GRanges.}

\item{n_frags}{Number of fragments to use for generating the windows. This 
should include restriction fragments with 0 counts (Default: 8).}

\item{sliding}{Numeric indicating the factor for generating sliding windows.
If set to 1 (default) will use fixed windows. If set to > 0 and < 1 will use
n_frags * sliding fragments to generate sliding windows.}
}
\value{
A GRanges object containing the windows of merged restriction 
fragments.
}
\description{
Use a set of continuous restriction fragments to generate windows containing
a fixed number of fragments (n_frags).
}
\examples{
data("ex_ciita_umi4c")

# Without sliding windows
win_frags <- makeWindowFragments(ex_ciita_umi4c, n_frags=30, sliding=1)
win_frags

# With sliding windows (n_frags*sliding)
win_frags <- makeWindowFragments(ex_ciita_umi4c, n_frags=30, sliding=0.5)
win_frags
}
