% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topTrendy.R
\name{topTrendy}
\alias{topTrendy}
\title{obtain top genes from trendy results}
\usage{
topTrendy(trendyOutData, adjR2Cut = 0.5)
}
\arguments{
\item{trendyOutData}{output from the trendy function}

\item{adjR2Cut}{cutoff for the adjusted R^2. Genes whose adjusted
R^2 is greater than adjR2Cut are called as significant.}
}
\value{
only significant genes will be included in the output. 
 The output is reformatted as:
 Trend direction of each sample; -1: down, 0: no change, 1: up
 Slope: fitted slopes, Slope.Trend: sign of fitted slopes, 
 Slope.Pvalue: p value of each segment, 
 Breakpoint: estimated breakpoints, Fitted.Values: fitted values 
 AdjustedR2: adjusted r value of the model
 Fit: fit object
}
\description{
reformats the list output for genes with a 
 given adjusted R^2 cutoff
}
\examples{
 d1 <- matrix(c(c(rnorm(50,5,1),sort(rnorm(50, 15, 5))), rnorm(100, 50,10)), 2, 100, TRUE)
 rownames(d1) <- c("g1","g2")
 colnames(d1) <- paste0("time", seq_len(100))
 seg.all <- trendy(d1)
 seg.all <- results(seg.all)
 top.genes <- topTrendy(seg.all)
}
