% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/classAccessor.R
\name{rowLinks}
\alias{rowLinks}
\alias{rowLinks,TreeSummarizedExperiment-method}
\alias{colLinks}
\alias{colLinks,TreeSummarizedExperiment-method}
\alias{rowTree}
\alias{rowTree,TreeSummarizedExperiment-method}
\alias{rowTree<-}
\alias{rowTree<-,TreeSummarizedExperiment-method}
\alias{colTree}
\alias{colTree,TreeSummarizedExperiment-method}
\alias{colTree<-}
\alias{colTree<-,TreeSummarizedExperiment-method}
\alias{rowTreeNames}
\alias{rowTreeNames,TreeSummarizedExperiment-method}
\alias{rowTreeNames<-}
\alias{rowTreeNames<-,TreeSummarizedExperiment-method}
\alias{colTreeNames}
\alias{colTreeNames,TreeSummarizedExperiment-method}
\alias{colTreeNames<-}
\alias{colTreeNames<-,TreeSummarizedExperiment-method}
\alias{referenceSeq}
\alias{referenceSeq,TreeSummarizedExperiment-method}
\alias{referenceSeq<-}
\alias{referenceSeq<-,TreeSummarizedExperiment-method}
\alias{[,TreeSummarizedExperiment,ANY,ANY,ANY-method}
\alias{[<-,TreeSummarizedExperiment,ANY,ANY,TreeSummarizedExperiment-method}
\alias{rownames<-,TreeSummarizedExperiment-method}
\alias{colnames<-,TreeSummarizedExperiment-method}
\alias{subsetByLeaf}
\alias{subsetByLeaf,TreeSummarizedExperiment-method}
\alias{subsetByNode}
\alias{subsetByNode,TreeSummarizedExperiment-method}
\alias{TreeSummarizedExperiment-accessor}
\title{TreeSummarizedExperiment-accessors}
\usage{
rowLinks(x)

\S4method{rowLinks}{TreeSummarizedExperiment}(x)

colLinks(x)

\S4method{colLinks}{TreeSummarizedExperiment}(x)

rowTree(x, whichTree = 1, value)

\S4method{rowTree}{TreeSummarizedExperiment}(x, whichTree = 1, value)

rowTree(x, whichTree = 1) <- value

\S4method{rowTree}{TreeSummarizedExperiment}(x, whichTree = 1) <- value

colTree(x, whichTree = 1)

\S4method{colTree}{TreeSummarizedExperiment}(x, whichTree = 1)

colTree(x, whichTree = 1) <- value

\S4method{colTree}{TreeSummarizedExperiment}(x, whichTree = 1) <- value

rowTreeNames(x, value)

\S4method{rowTreeNames}{TreeSummarizedExperiment}(x, value)

rowTreeNames(x) <- value

\S4method{rowTreeNames}{TreeSummarizedExperiment}(x) <- value

colTreeNames(x, value)

\S4method{colTreeNames}{TreeSummarizedExperiment}(x, value)

colTreeNames(x) <- value

\S4method{colTreeNames}{TreeSummarizedExperiment}(x) <- value

referenceSeq(x)

\S4method{referenceSeq}{TreeSummarizedExperiment}(x)

referenceSeq(x) <- value

\S4method{referenceSeq}{TreeSummarizedExperiment}(x) <- value

\S4method{[}{TreeSummarizedExperiment,ANY,ANY,ANY}(x, i, j, ..., drop = TRUE)

\S4method{[}{TreeSummarizedExperiment,ANY,ANY,TreeSummarizedExperiment}(x, i, j, ...) <- value

\S4method{rownames}{TreeSummarizedExperiment}(x) <- value

\S4method{colnames}{TreeSummarizedExperiment}(x) <- value

subsetByLeaf(
  x,
  rowLeaf,
  colLeaf,
  whichRowTree,
  whichColTree,
  updateTree = TRUE
)

\S4method{subsetByLeaf}{TreeSummarizedExperiment}(
  x,
  rowLeaf,
  colLeaf,
  whichRowTree,
  whichColTree,
  updateTree = TRUE
)

subsetByNode(x, rowNode, colNode, whichRowTree, whichColTree)

\S4method{subsetByNode}{TreeSummarizedExperiment}(x, rowNode, colNode, whichRowTree, whichColTree)
}
\arguments{
\item{x}{A TreeSummarizedExperiment object}

\item{whichTree}{A numeric indicator or name character to specify which tree
in the \code{rowTree} or \code{colTree} to be extracted. The default is to
extract the first tree. If \code{whichTree = NULL}, a list of all trees is
extracted.}

\item{value}{\itemize{
  \item{the new rownames or colnames as a \code{character} value. See
    \code{\link[BiocGenerics:row_colnames]{BiocGenerics}}.}
  \item{A \code{\link[Biostrings:XStringSet-class]{DNAStringSet}}
    object or an object coercible to one}
}}

\item{i, j}{The row, column index to subset \code{x}. The arguments of the
subset function \code{[]}}

\item{...}{The argument from the subset function \code{[]}}

\item{drop}{A logical value, TRUE or FALSE. The argument from the subset
function \code{[]}}

\item{rowLeaf}{A vector of leaves that are used to subset rows. One could use
the leaf number, or the leaf label to specify nodes, but not a mixture of
them.}

\item{colLeaf}{A vector of leaves that are used to subset columns. One could
use the leaf number, or the leaf label to specify nodes, but not a mixture
of them.}

\item{whichRowTree}{A numeric indicator or name character to specify which tree
in the \code{rowTree}.}

\item{whichColTree}{A numeric indicator or name character to specify which tree
in the \code{colTree}.}

\item{updateTree}{TRUE or FALSE. Default is TRUE, which updates tree
structures after subsetting.}

\item{rowNode}{A vector of nodes that are used to subset rows. One could use
the node number, the node label or the node alias to specify nodes, but not
a mixture of them.}

\item{colNode}{A vector of nodes that are used to subset columns. One could
use the node number, the node label or the node alias to specify nodes, but
not a mixture of them.}
}
\value{
Elements from \code{TreeSummarizedExperiment}.
}
\description{
All accessor functions that work on
\code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}}
should work on \strong{TreeSummarizedExperiment}. Additionally, new accessors
\code{rowLinks} \code{colLinks}, \code{rowTree} and \code{colTree} accessor
function are available for \strong{TreeSummarizedExperiment}.
}
\examples{

# the assay table
set.seed(1)
y <- matrix(rnbinom(300,size=1,mu=10),nrow=10)
colnames(y) <- paste(rep(LETTERS[1:3], each = 10), rep(1:10,3), sep = "_")
rownames(y) <- tinyTree$tip.label

# the row data
rowInf <- DataFrame(var1 = sample(letters[1:3], 10, replace = TRUE),
                    var2 = sample(c(TRUE, FALSE), 10, replace = TRUE))
# the column data
colInf <- DataFrame(gg = factor(sample(1:3, 30, replace = TRUE)),
                    group = rep(LETTERS[1:3], each = 10))

# the tree structure on the rows of assay tables
data("tinyTree")

# the tree structure on the columns of assay tables
sampTree <- ape::rtree(30)
sampTree$tip.label <- colnames(y)

# create the TreeSummarizedExperiment object
toy_tse <- TreeSummarizedExperiment(assays = list(y),
                                    rowData = rowInf,
                                    colData = colInf,
                                    rowTree = tinyTree,
                                    colTree = sampTree)

## extract the rowData
(rowD <- rowData(x = toy_tse))

## extract the colData
(colD <- colData(x = toy_tse))

## extract the linkData
# on rows
(rowL <- rowLinks(x = toy_tse))
# on columns
(colL <- colLinks(x = toy_tse))

 ## extract the treeData
# on rows
(rowT <- rowTree(x = toy_tse))
# on columns
(colT <- colTree(x = toy_tse))

# the referenceSeq data
refSeq <- DNAStringSetList(one = DNAStringSet(rep("A",nrow(toy_tse))),
                           two = DNAStringSet(rep("B",nrow(toy_tse))))
referenceSeq(toy_tse) <- refSeq
toy_tse

# subset treeSE by leaves
library(ape)
set.seed(1)
z <- makeTSE(nrow = 5, ncol = 4, include.rowTree = TRUE, include.colTree = FALSE)
y <- makeTSE(nrow = 4, ncol = 4, include.rowTree = TRUE, include.colTree = FALSE)
tr <- ape::rtree(4)
zy <- rbind(z, y)
x <- changeTree(x = zy, rowTree = tr, whichRowTree = 2, rowNodeLab = tr$tip.label)
rowLinks(zy)
rowLinks(x)
## 1) rowLeaf exist only in one of trees
rf <- c("t1", "t3")
sx <- subsetByLeaf(x = x, rowLeaf = rf)
rowLinks(sx)

sx <- subsetByLeaf(x = x, rowLeaf = rf, updateTree = FALSE)
rowLinks(sx)

## 2) rowLeaf exist in all trees
rf <- 1:3
sxx <- subsetByLeaf(x = x, rowLeaf = rf)
rowLinks(sxx)



## 3) rowLeaf exist in all trees, but subset and update only the specified
trees
rf <- c(3:4)
sxx <- subsetByLeaf(x = x, rowLeaf = rf, whichRowTree = "phylo")
rowLinks(sxx)
}
\seealso{
\code{\link{TreeSummarizedExperiment}}
  \code{\link[SingleCellExperiment:SingleCellExperiment]{SingleCellExperiment}}
}
\author{
Ruizhu HUANG
}
