% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TrajectoryGeometry.R
\name{getStepLengths}
\alias{getStepLengths}
\title{Find the step lengths:}
\usage{
getStepLengths(path, from = 1, to = nrow(path), d = ncol(path))
}
\arguments{
\item{path}{- This is an mxn dimensional matrix. Each row is
considered a point.}

\item{from}{- The starting place along the path which will be
treated as the center of the sphere.  This defaults to 1.}

\item{to}{- The end point of the path.  This defaults to
nrow(path).}

\item{d}{- The dimension under consideration.  This defaults to
ncol(path)}
}
\value{
This function returns the length of each step in a path.
}
\description{
This finds the lengths of the steps along a path
}
\examples{
stepLengths = getStepLengths(path=crooked_path)
stepLengths = getStepLengths(path=crooked_path,from=4)
}
