\name{quantMatrix}
\alias{quantMatrix}
\title{Create an intensity matrix using quantification masses}
\description{
 Create an intensity matrix using quantification masses. The quantification
 masses can be specified when importing the library file or automatically.
}
\usage{
quantMatrix(Lib, metabProfile, value=c("quantmass", "maxint", "maxobs"), selmass=FALSE)
}
\arguments{
  \item{Lib}{A \code{tsLib} object created by \code{\link{ImportLibrary}} function.}
  \item{metabProfile}{ A \code{tsProfile} object. The final result of the package.
      This object is generated by either \code{Profile} or \code{ProfileCleanUp}.}
  \item{value}{The method to select automatically the quantification mass. The options
      are: \dQuote{maxint} which selects the selective mass with the highest median
      intensity across all samples; \dQuote{maxobs} which selects the mass which the
      most observations (the one with fewer missing values; or \dQuote{quantmass}
      which uses the selected quantification mass defined by the library}
  \item{selmass}{ Logical. If \code{TRUE}, then only selective masses are considered
      if the option \code{value} is either \dQuote{maxint} or \dQuote{maxobs},
      otherwise all masses are considered (the default behavior). If \code{value}
      is \dQuote{quantmass}, this argument has no effect}
}
\value{
  An intensity matrix with metabolites as rows and samples as columns. The column
  names are the sample names of the respective \code{tsSample} object and the rownames
  correspond with the library unique identifiers.

  In addition, the matrix has these attributes:
  \itemize{
    \item \dQuote{quantMass} is a numeric vector that contains the quantification masses
      that was selected.
    \item \dQuote{isSelMass} is a logical vector that indicates whether the quantification
      mass is also a selected mass.
    \item \dQuote{isCorMass} to indicate that the mass is one of the correlating masses.
    \item \dQuote{libNames} the metabolite names (a character vector).
  }
}
\examples{
require(TargetSearchData)
data(TSExample)

# process chromatograms and get a profile
RI.path <- tsd_data_path()
RIpath(sampleDescription) <- RI.path
refLibrary    <- ImportLibrary(tsd_file_path('library.txt'))
refLibrary    <- medianRILib(sampleDescription, refLibrary)
corRI         <- sampleRI(sampleDescription, refLibrary, r_thres = 0.95)
peakData      <- peakFind(sampleDescription, refLibrary, corRI)
metabProfile  <- Profile(sampleDescription, refLibrary, peakData, r_thres = 0.95)

# get a Matrix using use default values, ie, use the quantification masses
# defined in the library
quantMat <- quantMatrix(refLibrary, metabProfile)
quantMat

# use 'maxint' to select the metabolites with the highest median intensity
quantMat <- quantMatrix(refLibrary, metabProfile, 'maxint')

# use 'maxobs' to select the metabolites with the most observed values
quantMat <- quantMatrix(refLibrary, metabProfile, 'maxobs')
}
\author{Alvaro Cuadros-Inostroza}
\seealso{ \code{\linkS4class{tsLib}}, \code{\linkS4class{tsMSdata}} }
% vim: set ts=2 sw=2 et:
