% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netCDF.R
\name{ncdf4_update_ri}
\alias{ncdf4_update_ri}
\title{Update retention time index on a NCDF4 file}
\usage{
ncdf4_update_ri(cdfFile, observed, standard)
}
\arguments{
\item{cdfFile}{Path to the CDF file}

\item{observed}{The observed RI markers retention times'.}

\item{standard}{The RI of said markers.}
}
\value{
Returns \code{invisible}
}
\description{
Performs retention time index (RI) correction on a CDF file, using the
retention markers found by \code{\link[=RIcorrect]{RIcorrect()}}, or to force the markers time
if, for example, the RI markers were not co-injected with the biological
samples. It wraps around \code{\link[=rt2ri]{rt2ri()}}
}
\details{
This function is similar to \code{\link[=fixRI]{fixRI()}}, with the difference that is acts
upon a single file, whereas \code{\link[=fixRI]{fixRI()}} requires a \linkS4class{tsSample}
object.
}
\note{
This function is meant to be used internally. It is exposed for convenience.
}
\seealso{
\code{\link{fixRI}}, \code{\link{RIcorrect}}, \code{\link{ImportFameSettings}}
}
\author{
Alvaro Cuadros-Inostroza
}
\examples{
# pull a CDF file from package TargetSearchData as example
require(TargetSearchData)
cdffile <- tsd_cdffiles()[9]

# we need to convert from NCDF3 to NCDF4 in this example
# (NCDF3 files do not work)
nc4file <- ncdf4_convert(cdffile, 'example.nc4')

# to update the RI we need to pass two equal-length vectors of
# observed RT and standard RI values.
obsRT <- c(252, 311, 369) # approx time of RI markers
stdRI <- c(262320, 323120, 381020) # the exact RI of the markers

# finally update the RI for these file
ncdf4_update_ri(nc4file, obsRT, stdRI)
}
