% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write_analysis.R
\name{write_tsar}
\alias{write_tsar}
\title{write output files}
\usage{
write_tsar(data, name, file = "txt")
}
\arguments{
\item{data}{input data frame}

\item{name}{string, name file to be saved as. Final name will be appended
"tsar_output"}

\item{file}{\code{file = "txt"} writes txt output files;
\code{file = "csv"} writes csv output files;
default set to \code{file = "txt"}}
}
\value{
file output on the working directory where data was read in
}
\description{
writes output into csv or txt files
}
\examples{
data("qPCR_data1")
result <- gam_analysis(qPCR_data1,
    smoothed = TRUE, fluo_col = 5,
    selections = c(
        "Well.Position", "Temperature", "Fluorescence", "Normalized"
    )
)
output_data <- read_tsar(result, output_content = 2)
# example does not run, will build excessive file in package
# write_tsar(output_data, name = "2022_03_18_test", file = "txt")

}
\seealso{
Other read_write_analysis: 
\code{\link{join_well_info}()},
\code{\link{read_tsar}()}
}
\concept{read_write_analysis}
