% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsa_curves.R
\name{TSA_wells_plot}
\alias{TSA_wells_plot}
\title{TSA Well Curves Plot}
\usage{
TSA_wells_plot(
  tsa_data,
  y = "RFU",
  show_Tm = TRUE,
  Tm_label_nudge = 7.5,
  show_average = TRUE,
  plot_title = NA,
  plot_subtitle = NA,
  smooth = TRUE,
  separate_legend = TRUE
)
}
\arguments{
\item{tsa_data}{a data frame that is merged and generated by
TSAR::merge_TSA(). If \code{y = 'RFU'}, tsa_data must also be
generated by TSAR::normalize_fluorescence. The Temperature column will be
rounded and the average & sd of each rounded temperature is calculated.}

\item{y}{character string; c('Fluorescence', 'RFU').
When \code{y = 'Fluorescence'}, the original Fluorescence data from
TSAR::read_raw_data() is averaged. When \code{y = 'RFU'}, the average is
calculated by the rescaled fluorescence.}

\item{show_Tm}{logical; \code{show_Tm = TRUE} by default. When TRUE, the Tm
is displayed on the plot. When FALSE, the Tm is not added to the plot.}

\item{Tm_label_nudge}{numeric; \code{Tm_label_nudge = 7.5} the direction
in the x direction to move the Tm label. This is used prevent the label
from covering data. Ignored if \code{show_Tm = FALSE}.}

\item{show_average}{logical; \code{show_average = TRUE} by default.
When TRUE, the average is and sd is plotted as
generated by \code{\link{merge_TSA}}.}

\item{plot_title, plot_subtitle}{characer string, NA by default.
User-specified plots to overright automatic naming.}

\item{smooth}{logical; \code{smooth = TRUE} by default. When TRUE, linear
regression by \code{\link[mgcv]{gam}} is used to make clean lines on
the plot. See \code{\link{TSA_average}} for more details. When FALSE,
individual points are plotted (slows down rendering).}

\item{separate_legend}{logical; \code{separate_legend = TRUE} by default.
When TRUE, the ggplot2 legend is separated from the TSA curve.
This is to help with readability. One ggplot is returned when FALSE.}
}
\value{
by default, two ggplots are returned: one TSA curve and one key.
    When \code{separate_legend = FALSE} one ggplot is returned.
}
\description{
Generates the individual curves for each well in the merged tsa data input.
    Options to create an average and standard deviation sd of the plot
    in addition to the individual curves. The average and sd will be
    smoothened by linear regression; see \code{\link{TSA_average}} for
    details.
}
\examples{
data("example_tsar_data")
check <- subset(example_tsar_data, condition_ID == "CA FL_PyxINE HCl")
TSA_wells_plot(check, separate_legend = FALSE)

}
\seealso{
\code{\link{merge_TSA}} and \code{\link{normalize_fluorescence}}
    for preparing data. See \code{\link{TSA_average}} and
    \code{\link{get_legend}} for details on function parameters.

Other TSA Plots: 
\code{\link{TSA_boxplot}()},
\code{\link{TSA_compare_plot}()},
\code{\link{get_legend}()},
\code{\link{graph_tsar}()},
\code{\link{view_deriv}()}
}
\concept{TSA Plots}
