% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryTSA.R
\name{TSA_ligands}
\alias{TSA_ligands}
\title{TSA Ligands}
\usage{
TSA_ligands(tsa_data, n = FALSE)
}
\arguments{
\item{tsa_data}{a data frame that is merged and generated by
TSAR::merge_TSA(), or an unmerged data frame read by
TSAR::read_analysis() or TSAR::read_raw_data().
The data frame must have a column named 'Ligand'.}

\item{n}{logical value; \code{n = FALSE} by default. When TRUE, a numeric
value describing the number of unique ligand names is returned.
When FALSE, a character vector of unique IDs are returned.}
}
\value{
Either a character vector of unique well_IDs or a numeric value.
}
\description{
This function is used to extract information from a data frame of TSA data.
    The Ligand values should be assigned in the TSA software.
}
\examples{
data("example_tsar_data")
TSA_ligands(example_tsar_data)

}
\seealso{
\code{\link{merge_TSA}}, \code{\link{read_raw_data}},
    and \code{\link{read_analysis}} for preparing input.

Other TSA Summary Functions: 
\code{\link{TSA_proteins}()},
\code{\link{condition_IDs}()},
\code{\link{well_IDs}()}
}
\concept{TSA Summary Functions}
