% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.functions.R
\name{keysToNames}
\alias{keysToNames}
\title{keysToNames}
\usage{
keysToNames(x, matrix)
}
\arguments{
\item{x}{A TRONCO compliant dataset.}

\item{matrix}{A matrix with colnames/rownames which represent genotypes keys.}
}
\value{
The matrix with intelligible colnames/rownames.
}
\description{
Convert colnames/rownames of a matrix into intelligible event names, e.g., change a key G23 in 'Mutation KRAS'.
If a name is not found, the original name is left unchanged.
}
\examples{
data(test_model)
adj_matrix = as.adj.matrix(test_model, events=as.events(test_model)[5:15,])$capri_bic
keysToNames(test_model, adj_matrix)


}
