% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.functions.R
\name{as.confidence}
\alias{as.confidence}
\title{as.confidence}
\usage{
as.confidence(x, conf, models = names(x$model))
}
\arguments{
\item{x}{A TRONCO model.}

\item{conf}{A vector with any of 'tp', 'pr', 'hg', 'npb', 'pb', 'sb', 'eloss', 'prederr' or 'posterr'.}

\item{models}{The name of the models to extract, all by default.}
}
\value{
A list of matrices with the event-to-event confidence.
}
\description{
Return confidence information for a TRONCO model. Available information are: temporal priority (tp), 
probability raising (pr), hypergeometric test (hg), parametric (pb), non parametric (npb) or 
statistical (sb) bootstrap, entropy loss (eloss), prediction error (prederr).
Confidence is available only once a model has been reconstructed with any of the algorithms implemented
in TRONCO. If more than one model has been reconstructed - for instance via multiple regularizations - 
confidence information is appropriately nested. The requested confidence is specified via 
vector parameter \code{conf}.
}
\examples{
data(test_model)
as.confidence(test_model, conf='tp')
as.confidence(test_model, conf=c('tp', 'hg'))

}
