% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpp2dCalcFractAbundance.R
\name{tpp2dCalcFractAbundance}
\alias{tpp2dCalcFractAbundance}
\title{Calculate fractional abundance and DMSO ratio of successive sumionareas  
  (usage of function is only reasonable when at least two temperatures are multiplexed!)}
\usage{
tpp2dCalcFractAbundance(
  configTable = NULL,
  data,
  intensityStr = NULL,
  idVar = NULL
)
}
\arguments{
\item{configTable}{DEPCRECATED}

\item{data}{data frame of TPP-CCR results (e.g. obtained by \code{run2DTPPCCR}).}

\item{intensityStr}{DEPCRECATED}

\item{idVar}{DEPCRECATED}
}
\value{
Data frame that was handed over with additional columns of fractional abundance
  and DMSO1 vs DMSO2 ratio
}
\description{
Calculates fractional abundance and DMSO ratio of successive sumionareas and 
  creates respective columns which are added two the data frame which is handed over
}
\examples{
data(panobinostat_2DTPP_smallExample)

# Import data:
datIn <- tpp2dImport(configTable = panobinostat_2DTPP_config,
                      data = panobinostat_2DTPP_data,
                      idVar = "representative",
                      addCol = "clustername",
                      intensityStr = "sumionarea_protein_",
                      nonZeroCols = "qusm")

# View attributes of imported data (experiment infos and import arguments):
attr(datIn, "importSettings") \%>\% unlist
attr(datIn, "configTable")

# Compute fractional abundance:
datDMSORatio <- tpp2dCalcFractAbundance(data = datIn)
colnames(datDMSORatio)

}
