% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpp2dAddAdditionalInfo.R
\name{tpp2dAddAdditionalInfo}
\alias{tpp2dAddAdditionalInfo}
\title{Add additional info to 2D-TPP CCR output data}
\usage{
tpp2dAddAdditionalInfo(data, idVar = "gene_name")
}
\arguments{
\item{data}{output table returned by the \code{tpp2dCurveFit} function}

\item{idVar}{character string indicating which column of the data table contains unique
protein ids}
}
\value{
A data frame to which additional data like how often a protein has been (de-)stabilized
 has been attached
}
\description{
Adds additional info to 2D-TPP CCR output data, like counts on how often a 
  certain protein was stabilized or destabilized
}
\examples{
load(system.file("example_data/2D_example_data/shortCCRresults.RData", package="TPP"))
shortCCRresults <- tpp2dAddAdditionalInfo(data = shortCCRresults, idVar="representative")

}
