% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TOP_survival.R
\name{Surv_TOP_CI}
\alias{Surv_TOP_CI}
\title{Create a function to calculate the concordance index.}
\usage{
Surv_TOP_CI(TOP_survival, newx, newy)
}
\arguments{
\item{TOP_survival}{A TOP_survival model. See \code{\link{TOP_survival}}.}

\item{newx}{A new data.frame to predict the survival time.}

\item{newy}{A data.frame, where the first columns in each data frame is the
time and the second column is the event status.}
}
\value{
An object of class concordance
}
\description{
FUNCTION_DESCRIPTION
}
\examples{
data(TOP_data_binary, package = "TOP")
time <- rpois(300, c(600, 1000))
surv <- sample(c(0, 1), 300, replace = TRUE)
y <- data.frame(time, surv)

batch <- rep(paste0("y", 1:3), c(100, 100, 100))
y_list <- y |> split(batch)

x_list <- list(TOP_data_binary$x1, TOP_data_binary$x2, TOP_data_binary$x3)

surv_model <- TOP_survival(x_list[-3], y_list[-3], nFeatures = 10)
Surv_TOP_CI(surv_model, newx = x_list[[3]], newy = y_list[[3]])
}
