#' An example read Counts table
#'
#' A dataset of exemplary read counts
#'
#' @docType data
#' @keywords datasets
#' @name countsTable
#' @usage data(countsTable)
#' @format A data frame containing experiment design information
#' for 12 samples/libraries.
#' @return
#' A data frame
#' @examples
#' data(countsTable)
NULL

#' An example experiment design without BAM file infomration
#'
#' A dataset of exemplary experiment design without BAM file
#' infomration
#'
#' @docType data
#' @keywords datasets
#' @name experiment
#' @usage data(experiment)
#' @format A data frame containing experiment design information
#' for 12 samples/libraries.
#' @return
#' A data frame
#' @examples
#' data(experiment)
NULL

#' An example experiment design with BAM file infomration
#'
#' A dataset of exemplary experiment design with BAM file
#' infomration
#'
#' @docType data
#' @keywords datasets
#' @name experiment_BAMfile
#' @usage data(experiment_BAMfile)
#' @format A data frame containing experiment design information
#' for 12 samples/libraries.
#' @return
#' A data frame
#' @examples
#' data(experiment_BAMfile)
NULL

#' An example reference genomic regions
#'
#' A dataset of exemplary genomic regions
#'
#' @docType data
#' @keywords datasets
#' @name genomicIntervals
#' @usage data(genomicIntervals)
#' @format A data frame containing 2751 genomic regions.
#' @return
#' A data frame
#' @examples
#' data(genomicIntervals)
NULL

#' An example TCA object
#'
#' A TCA object storing exemplary ATAC-seq time course data,
#' including the experiment design, read counts, reference
#' genomic regions.
#'
#' @docType data
#' @keywords datasets
#' @name tca_ATAC
#' @usage data(tca_ATAC)
#' @format A TCA object of exemplary ATAC-seq time course data
#' @return
#' A TCA object
#' @examples
#' data(tca_ATAC)
NULL

