% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCGAsampleSelect.R
\name{TCGAsampleSelect}
\alias{TCGAsampleSelect}
\title{Select samples from barcodes from lookup table}
\usage{
TCGAsampleSelect(barcodes, sampleCodes)
}
\arguments{
\item{barcodes}{Either a TCGA barcode vector or
\link[IRanges:AtomicList-class]{CharacterList} containing patient
identifiers, sample, portion, plate, and center codes.}

\item{sampleCodes}{Either a character or numeric vector of TCGA sample codes.
See the \code{sampleType} dataset.}
}
\value{
A logical vector or \link[IRanges:AtomicList-class]{LogicalList} of the
same length as 'barcodes' indicating sample type matches
}
\description{
The TCGA barcode contains several pieces of information which can
be parsed by the \link{TCGAbarcode} function. To select a specific type of
sample, enter the appropriate sampleCode argument from the lookup table.
See lookup table in \code{data("sampleTypes")}. Barcode inputs can be a
character vector or a \link[IRanges:AtomicList-class]{CharacterList} object.
}
\examples{

example("TCGAbarcode")
TCGAsampleSelect(barcodes, c(11, 01))

}
