% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OriginalModel.R
\name{.OriginalModel_Retraining}
\alias{.OriginalModel_Retraining}
\title{TB gene signatures that require retraining.}
\usage{
.OriginalModel_Retraining(input, useAssay, geneSignaturesName, adj, BPPARAM)
}
\arguments{
\item{input}{A SummarizedExperiment object with gene symbols as the assay row
names.}

\item{useAssay}{A character string or an integer specifying the assay in the
\code{input}. Default is the first assay in the assay list.
Used for the test SummarizedExperiment object. Default is \code{1}, indicating the
first assay in the \code{input}.}

\item{geneSignaturesName}{A character string/vector specifying the signature
of interest. If \code{any(geneSignaturesName == "") == TRUE}, it will run all
available gene signatures' original models.}

\item{adj}{A small positive real number used in \code{\link[sva]{ComBat}} to solve
for genes with 0 counts(rare cases). Default is \code{1e-3}.}

\item{BPPARAM}{An instance inherited from \code{\link[BiocParallel]{bplapply}}.}
}
\value{
A SummarizedExperiment object with predicted scores for each sample
obtained from the signature's original model.
}
\description{
A function to obtain predicted score for TB gene signatures that need retraining of original models.
}
\details{
Maertzdorf_4 and Maertzdorf_15 were trained using a random forest to distinguish
patients with active TB from healthy controls.

Verhagen_10 was also trained using a random forest to distinguish samples with active TB
from either latent infection or healthy controls.
The random forest model was build using \code{\link[randomForest]{randomForest}}.\cr

Jacobsen_3 were trained using linear discriminant analysis (LDA)
to distinguish samples with active TB from latent infection status.

Sambarey_HIV_10 were also trained using LDA to distinguish samples with active TB
from either latent infection, healthy control, or other disease (HIV).
The LDA model was built using \code{\link[MASS]{lda}}.\cr

Berry_OD_86 and Berry_393 were trained using K-nearest neighbors (KNN) model to
differentiate samples with active TB from latent infection status.
The KNN model was built using \code{\link[class]{knn}}.\cr

Suliman_RISK_4 and Zak_RISK_16 were trained using support vector machines (SVM)
to distinguish TB progressor from non-progressors. The input gene expression features
for Suliman_RISK_4 used the paired ratio of GAS6/CD1C, SEPTIN4/BLK, SEPTIN4/CD1C, GAS6/BLK.
The SVM model was built using \code{\link[e1071]{svm}}.
}
