% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_txs_seq.R
\name{getTxsSeq}
\alias{getTxsSeq}
\alias{getTxsSeq,GRangesList-method}
\alias{getTxsSeq,GRanges-method}
\title{Get transcript sequences}
\usage{
getTxsSeq(transcripts, genome)

\S4method{getTxsSeq}{GRangesList}(transcripts, genome)

\S4method{getTxsSeq}{GRanges}(transcripts, genome)
}
\arguments{
\item{transcripts}{A \code{\link[GenomicRanges:GRanges-class]{GRanges}} or
\code{\link[GenomicRanges:GRangesList-class]{GRangesList}} object containing exons of
transcripts for which sequences should be extracted. All exons in a \code{GRanges} object are
assumed to belong to the same transcript. Multiple transcripts can be provided in a
\code{GRangesList} object.}

\item{genome}{A \code{\link[BSgenome:BSgenome-class]{BSgenome}} or
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}} object containing chromosome sequences
which should be used to extract transcript sequences. Although using a \code{BSgenome} object
is the easiest way, the genome sequence could also be loaded from a FASTA file using
\code{\link[Biostrings:XStringSet-io]{readDNAStringSet}}.}
}
\value{
A \code{\link[Biostrings:DNAString-class]{DNAString}} or
  \code{\link[Biostrings:XStringSet-class]{DNAStringSet}} object containing the transcript
  sequence(s).
}
\description{
Extract the DNA sequences of all exons of transcript models and concatenate to one sequence per
transcript. This is basically a wrapper for \code{\link[GenomicFeatures]{extractTranscriptSeqs}},
which makes sure that the exons are correctly sorted according to their position in the
transcript (3' to 5').
}
\section{Methods (by class)}{
\itemize{
\item \code{getTxsSeq(GRangesList)}: Obtain transcript sequence from \code{GRangesList} input

\item \code{getTxsSeq(GRanges)}: Obtain transcript sequence from \code{GRanges} input

}}
\examples{
library(BSgenome)

# protein-coding exons of transcripts within chr11 region
data("chr11_genes")
target_txs <- split(chr11_genes, f = chr11_genes$transcript_id)

# human genome (hg38) BSgenome object (needs to be installed separately from Bioconductor)
hg38 <- getBSgenome("BSgenome.Hsapiens.UCSC.hg38")

# get sequences for all target transcripts on chr11
txs_seqs <- getTxsSeq(target_txs, genome = hg38)
}
