% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dinu_to.R
\name{dinu_to}
\alias{dinu_to}
\alias{dinu_to,regioned_dna-method}
\title{Maximize or minimize the usage of certain dinucleotide.}
\usage{
dinu_to(object, max.dinu = NA, min.dinu = NA, keep = FALSE, numcode = 1, ...)

\S4method{dinu_to}{regioned_dna}(object, max.dinu, min.dinu, keep, numcode)
}
\arguments{
\item{object}{A regioned_dna object.}

\item{max.dinu}{A string of a dinucleotide.}

\item{min.dinu}{A string of a dinucleotide.}

\item{keep}{A logical varibale stating if the codon usage of the original
sequences should be keep. Default: False.}

\item{numcode}{The ncbi genetic code number for translation. Default value: \code{1}. Details please refer to \code{?seqinr::translate} ("https://rdrr.io/cran/seqinr/man/translate.html").}

\item{...}{...}
}
\value{
regioned_dna
}
\description{
Input string of a dinucleotide to either the "max.dinu = " or "min.codon = "
parameter to maximize or minimize the usage of certain codon in the sequence.
Using a greedy algorithm with priority given to dinucleotide12 or
dinucleotide23.
}
\details{
The detail strategy for this function please refer to:
https://koohoko.github.io/SynMut/algorithm.html
}
\examples{
filepath <- system.file("extdata", "example.fasta", package = "SynMut")
rgd.seq <- input_seq(filepath)
get_du(dinu_to(rgd.seq, max.dinu = "cg")) - get_du(rgd.seq)
get_du(dinu_to(rgd.seq, min.dinu = "AA")) - get_du(rgd.seq)
get_du(dinu_to(rgd.seq, max.dinu = "cg", keep = TRUE)) - get_du(rgd.seq)
get_cu(dinu_to(rgd.seq, max.dinu = "CG", keep = TRUE)) - get_cu(rgd.seq)
}
\seealso{
\code{\link{input_seq}}, \code{\link{codon_to}},
  \code{\link{codon_random}}, \code{\link{codon_mimic}}
}
