% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilityThresholdNeighborhood.R
\name{computeThresholdNeighborhood}
\alias{computeThresholdNeighborhood}
\title{Probability threshold for neighborhood classification}
\usage{
computeThresholdNeighborhood(test.repA, test.repB)
}
\arguments{
\item{test.repA}{data.frame; test predictions, observation and
probablity vectors for each protein in replicate A}

\item{test.repB}{data.frame; test predictions, observation and
probablity vectors for each protein in replicate B}
}
\value{
threshold.neighborhood.df
}
\description{
Thresholds for each neighborhood are decided to get
confident predictions.
}
\examples{
{

df <- loadData(SubCellBarCode::hcc827Ctrl)

c.prots <- calculateCoveredProtein(rownames(df), markerProteins[,1])

set.seed(7)
c.prots <- sample(c.prots, 600)
cls <- svmClassification(c.prots, df, markerProteins)

test.A <- cls[[1]]$svm.test.prob.out
test.B <- cls[[2]]$svm.test.prob.out

t.n.df <- computeThresholdNeighborhood(test.A, test.B)
}
}
