% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{fraction_eval}
\alias{fraction_eval}
\title{Create a barplot of TRUE vs estimated cfs}
\usage{
fraction_eval(Statescope, true_fractions)
}
\arguments{
\item{Statescope}{SummarizedExperiment object from BLADE_deconvolution}

\item{true_fractions}{s4 Dataframe with true fractions to compare with
estimated fractions}
}
\value{
A barplot rendered to the active graphics device
}
\description{
Create a barplot of TRUE vs estimated cfs
}
\examples{
## Load True fractions
load(system.file("extdata", "example_true_fractions.RData",
    package = "StatescopeR"))

## Load Deconvolved Statescope object
load(system.file("extdata", "example_Statescope_Deconvolved.RData",
    package = "StatescopeR"))

## ## Plot fraction correlation and RMSE per ct
fraction_eval(Statescope, true_fractions)
}
