% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StateDiscovery.R
\name{StateDiscovery}
\alias{StateDiscovery}
\title{Run StateDiscovery}
\usage{
StateDiscovery(
  Statescope,
  k = NA,
  max_clusters = 10L,
  n_iter = 10L,
  n_final_iter = 100L,
  min_cophenetic = 0.9,
  Ncores = 1L
)
}
\arguments{
\item{Statescope}{SummarizedExperiment object from Statescope Refinement.}

\item{k}{number of cluster to choose, default is NA for automatic selection}

\item{max_clusters}{maximum allowed states per cell type.}

\item{n_iter}{Number of initial cNMF restarts.}

\item{n_final_iter}{Number of final cNMF restarts.}

\item{min_cophenetic}{Minimum cophenetic coefficient to determine K.}

\item{Ncores}{number of cores to use for paralellization.}
}
\value{
SummarizedExperiment object with statescores per celltype added
}
\description{
\code{StateDiscovery.R} Discovers states from refined ct-specific gep
}
\examples{
## Load Refined Statescope object
load(system.file("extdata", "example_Statescope_Refined.RData",
    package = "StatescopeR"
))

## Discover states
Statescope <- StateDiscovery(Statescope, k = 2L, Ncores = 2L)

## Look at statescores and stateloadings
S4Vectors::metadata(Statescope)$statescores
S4Vectors::metadata(Statescope)$stateloadings

}
