% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Refinement.R
\name{Refinement}
\alias{Refinement}
\title{Run Refinement}
\usage{
Refinement(Statescope, signature, bulk, cores = 1L)
}
\arguments{
\item{Statescope}{SummarizedExperiment object from BLADE_deconvolution}

\item{signature}{SimpleList with mu and sigma, respectively mean
gene expression and mean-variance corrected variance per cell type}

\item{bulk}{mRNA to be refined}

\item{cores}{number of cores to use for paralellization}
}
\value{
updated SummarizedExperiment object with ct_specific_gep added
}
\description{
\code{Refinement.R} # Perform Gene Expression Refinement
}
\details{
This function takes the output from BLADE_deconvolution and refines the
cell type specific gene expression by reoptimizing the initial estimates.
It reoptimzes by fixing the estimated fractions and weighing the objective
function value in a way that it tries to resemble the bulk RNA expression
more than initially
}
\examples{
if (requireNamespace("scRNAseq", quietly = TRUE)) {
    library(scRNAseq)
    library(scuttle)
    ## Load SegerstolpePancreas data set
    scRNAseq <- SegerstolpePancreasData()

    ## remove duplicate genes
    scRNAseq <- scRNAseq[!duplicated(rownames(scRNAseq)), ]

    ## Subset to 1 healthy and 2 type 2 diabetes samples
    scRNAseq = scRNAseq[,scRNAseq$individual \%in\% c('H3',
                                               'T2D1', 'T2D2')]
    ## remove cells with no cell type label
    scRNAseq <- scRNAseq[, !is.na(scRNAseq$`cell type`)]

    ## remove very rare cell types (<100 cells in total data set)
    celltypes_to_remove <-names(table(scRNAseq$`cell type`)
        [(table(scRNAseq$`cell type`) < 100)])
    scRNAseq <- scRNAseq[, !scRNAseq$`cell type` \%in\% celltypes_to_remove]

    ## Create pseudobulk and normalize to cp10k
    pseudobulk <- aggregateAcrossCells(scRNAseq, ids = scRNAseq$individual)
    normcounts(pseudobulk) <- calculateCPM(pseudobulk)/100
    pseudobulk = as(pseudobulk, "SummarizedExperiment")
    rownames(pseudobulk) = rownames(scRNAseq)
    ## Load signature
    load(system.file("extdata", "example_signature.RData",
        package = "StatescopeR"))

    ## Load Deconvolved Statescope object
    load(system.file("extdata", "example_Statescope_Deconvolved.RData",
        package = "StatescopeR"))

    ## Run Refinement
    Statescope <- Refinement(Statescope, signature, pseudobulk, 2L)

    ## Show cell type specific gene expression profile estimates
    S4Vectors::metadata(Statescope)$ct_specific_gep
    }
}
