% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difference_functions.R
\name{calculate_fc}
\alias{calculate_fc}
\title{Calculate splicing diversity changes between two conditions.}
\usage{
calculate_fc(x, samples, control, method = "mean")
}
\arguments{
\item{x}{A \code{matrix} with the splicing diversity values.}

\item{samples}{Character vector with an equal length to the number of columns
in the input dataset, specifying the category of each sample.}

\item{control}{Name of the control sample category, defined in the
\code{samples} vector, e.g. \code{control = 'Normal'} or \code{control =
'WT'}.}

\item{method}{Method to use for calculating the average splicing diversity
value in a condition. Can be \code{'mean'} or \code{'median'}.}
}
\value{
A \code{data.frame} with mean or median value of splicing diversity
  across sample categories, the difference between these values and the log2
  fold change values.
}
\description{
Calculate splicing diversity changes between two conditions.
}
\details{
The function uses a matrix of splicing diversity values in order to
calculate mean or median differences and log2 fold changes between two
conditions.
}
