% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsBackend-functions.R
\name{fillCoreSpectraVariables}
\alias{fillCoreSpectraVariables}
\title{Fill spectra data  with columns for missing core variables}
\usage{
fillCoreSpectraVariables(
  x = data.frame(),
  columns = names(coreSpectraVariables())
)
}
\arguments{
\item{x}{\code{data.frame} or \code{DataFrame} with potentially present core
variable columns.}

\item{columns}{\code{character} with the names of the (core) spectra variables
that should be added if not already present in \code{x}. Defaults to
\code{columns = names(coreSpectraVariables())}.}
}
\value{
input data frame \code{x} with missing core variables added (with the
correct data type).
}
\description{
\code{fillCoreSpectraVariables()} fills a provided \code{data.frame}
with columns for eventually missing \emph{core} spectra variables.
The missing core variables are added as new columns with missing values
(\code{NA}) of the correct data type.
Use \code{\link[=coreSpectraVariables]{coreSpectraVariables()}} to list the set of core variables and their
data types.
}
\examples{

## Define a data frame
a <- data.frame(msLevel = c(1L, 1L, 2L), other_column = "b")

## Add missing core chromatogram variables to this data frame
fillCoreSpectraVariables(a)

## The data.frame thus contains columns for all core spectra
## variables in the respective expected data type (but filled with
## missing values).
}
