% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readXeniumSXE.R
\name{readXeniumSXE}
\alias{readXeniumSXE}
\title{Load data from a 10x Geonomics Xenium experiment}
\usage{
readXeniumSXE(
  dirName,
  returnType = "SPE",
  countMatPattern = "cell_feature_matrix.h5",
  metaDataPattern = "cells.parquet",
  coordNames = c("x_centroid", "y_centroid"),
  addExperimentXenium = TRUE,
  altExps = c("NegControlProbe", "UnassignedCodeword", "NegControlCodeword", "antisense",
    "BLANK"),
  addParquetPaths = TRUE,
  ...
)
}
\arguments{
\item{dirName}{a directory path to Xenium Output Bundle download that contains
files of interest.}

\item{returnType}{option of \code{"SPE"} or \code{"SCE"}, stands for
\code{SpatialExperiment} or \code{SingleCellExperiment} object. Default value \code{"SPE"}}

\item{countMatPattern}{a folder directory or the h5 file pattern for the count matrix.
Default value is \code{"cell_feature_matrix.h5"}, alternative value is
\code{"cell_feature_matrix"} that takes a bit longer. The count matrix is
read in and stored in a \code{SingleCellExperiment} object, using
\code{DropletUtils::read10xCounts()}}

\item{metaDataPattern}{a filename pattern of the zipped .csv file that
contains spatial coords. Default value is \code{"cells.csv.gz"}, and there is no
need to change.}

\item{coordNames}{a vector of two strings specify the spatial coord names.
Default value is \code{c("x_centroid", "y_centroid")}, and there is no need to change.}

\item{addExperimentXenium}{to add experiment.xenium parameters to \code{metadata(sxe)} or not.
Default value is TRUE.}

\item{altExps}{gene names contains these strings will be moved to \code{altExps(sxe)} as separate sxe-s.
Default is \code{c("NegControlProbe", "UnassignedCodeword", "NegControlCodeword", "antisense", "BLANK")}.}

\item{addParquetPaths}{to add parquet paths to \code{metadata(sxe)} or not. If TRUE,
transcripts, cell_boundaries, and nucleus_boundaries .parquet paths will be added to \code{metadata()}.
If, for instance, no cell_boundaries file is available, and transcript and nucleus_boundaries
files are available, please set this argument to TRUE and adjust \code{addCellBound = FALSE}
in the \code{...} argument. Default is TRUE.}

\item{...}{extra parameters to pass to \code{\link{addParquetPathsXenium}()}, including
\code{addTx}, \code{txMetaNames}, \code{txPattern}, \code{addCellBound}, \code{cellBoundMetaNames},
\code{cellBoundPattern}, \code{addNucBound}, \code{NucBoundMetaNames}, \code{NucBoundPattern}.}
}
\value{
a \code{\link{SpatialExperiment}} or a \code{\link{SingleCellExperiment}} object
}
\description{
Creates a \code{\link{SpatialExperiment}} from the downloaded unzipped Xenium
Output Bundle directory for 10x Genomics Xenium spatial gene expression data.
}
\details{
The constructor assumes the downloaded unzipped Xenium Output Bundle has the
following structure, with mandatory file of cells.csv.gz and either folder
/cell_feature_matrix or .h5 file cell_feature_matrix.h5:
Xenium_unzipped \cr
· | — cell_feature_matrix.h5 \cr
· | — cell_feature_matrix \cr
· · | - barcodes.tsv.gz \cr
· · | - features.tsv.gz \cr
· · | - matrix.mtx.gz \cr
· | — cells.parquet \cr

Optional files to add to the metadata() as a list of paths (will be converted to parquet):
· | — transcripts.parquet \cr
· | — cell_boundaries.parquet \cr
· | — nucleus_boundaries.parquet \cr
· | — experiment.xenium \cr
See addParquetPathsXenium()
}
\examples{
# A relatively small data set is the Xenium mouse brain data that can be 
# downloaded from 10X website.

# A mock .h5 and mock metadata with spatial location generated for a 4 genes by 
# 6 cells object is in /extdata: 

xepath <- system.file(
  file.path("extdata", "Xenium_small"),
  package = "SpatialExperimentIO")
  
list.files(xepath)

# One of the following depending on your input (.h5 or folder) and output 
# (`SPE` or `SCE`) requirement.
xe_spe <- readXeniumSXE(dirName = xepath)
\dontrun{
xe_spe <- readXeniumSXE(dirName = xepath, countMatPattern = "cell_feature_matrix")
}
xe_sce <- readXeniumSXE(dirName = xepath, returnType = "SCE")

xe_spe <- readXeniumSXE(dirName = xepath, addParquetPaths = TRUE)
xe_spe <- readXeniumSXE(dirName = xepath, addParquetPaths = TRUE, addNucBound = FALSE)

}
\author{
Yixing Estella Dong
}
