% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signatures.discovery.lasso.R
\name{startingBetaEstimation}
\alias{startingBetaEstimation}
\title{startingBetaEstimation}
\usage{
startingBetaEstimation(
  x,
  K = 3:10,
  background_signature = NULL,
  normalize_counts = TRUE,
  nmf_runs = 10,
  seed = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{count matrix for a set of n patients and 96 trinucleotides.}

\item{K}{numeric value (minimum 2) indicating the number of signatures to be discovered.}

\item{background_signature}{background signature to be used. If not provided, a warning is thrown and an initial value for it is 
estimated by NMF. If beta is not NULL, this parameter is ignored.}

\item{normalize_counts}{if true, the input count matrix x is normalize such that the patients have the same number of mutation.}

\item{nmf_runs}{number of iteration (minimum 1) of NMF to be performed for a robust estimation of starting beta. If beta is not NULL, 
this parameter is ignored.}

\item{seed}{Seed for reproducibility.}

\item{verbose}{boolean; Shall I print all messages?}
}
\value{
A list containing the starting beta values for each configuration of K.
}
\description{
Perform a robust estimation of the starting betas for the nmfLasso method
}
\examples{
data(background)
data(patients)
res = startingBetaEstimation(x=patients[1:100,],
     K=3:5,
     background_signature=background,
     nmf_runs=1,
     seed=12345)

}
