% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spanielPlot.R
\name{spanielPlot}
\alias{spanielPlot}
\title{Spatial Transcriptomics Plot}
\usage{
spanielPlot(object, 
grob = NULL, 
techType = 
"Original", 
byCoord = FALSE, 
imgDims = NULL, 
plotType = c("NoGenes", "CountsPerSpot", "Cluster", "Gene"), 
gene= NULL, 
clusterRes = NULL, 
customTitle = NULL, 
scaleData = TRUE,  
showFilter = NULL, 
ptSize = 2, 
ptSizeMin = 0, 
ptSizeMax = 5)
}
\arguments{
\item{object}{Either a Seurat object (version 3) or a SingleCellExperiment 
object containing barcode coordinates in the metadata (Seurat) or
colData (SingleCellExperiment).}

\item{grob}{an grob to be used as the backgound image see(parseImage). This 
is used for original Spatial Transcriptomics objects but not Visium}

\item{techType}{Either 1) "Original" (default) for the original Spatial 
Transcriptomics slides where the image has been cropped to the edge of the 
spots 2) "Visium" for 10X slides.}

\item{byCoord}{TRUE/FALSE option to plot original Spatial Transcriptomics data using pixel 
coordinates instead of by spot coordinates. Not required if techType = "Visium".
Default is FALSE.}

\item{imgDims}{pixel dimensions of histological image. Required when 
byCoord parameter is set to TRUE, Not required if techType = "Visium".}

\item{plotType}{There are 5 types of plots avaiable:
1) NoGenes - This shows the number of genes per spot 
and uses information from "nFeature_RNA" column of 
Seurat object or "detected" from a 
SingleCellExperiment object.
2) CountsPerSpot - This shows the number of counts per
spot. It uses information from "nCount_RNA" column of 
Seurat object or "sum" from a 
singleCellExperiment object.
3) Cluster - This plot is designed to show clustering
results stored in the meta.data or colData of an object
4) Gene- This plot shows the expression of a single 
gene. This plot uses scaled/normalised expressin data 
from the scale.data slot of Seurat object or logcounts 
of a SingleCellExperiment object.
5) Other - A generic plot to plot any column from the
meta.data or colData of an object.}

\item{gene}{Gene to plot}

\item{clusterRes}{which cluster resolution to plot}

\item{customTitle}{Specify plot title (optional)}

\item{scaleData}{Show scaled data on plot (default is TRUE)}

\item{showFilter}{Logical filter showing pass/fail for spots}

\item{ptSize}{Point size used for cluster plot default is 2}

\item{ptSizeMin}{Minimum point size used for QC and Gene Expression plots 
default is 0}

\item{ptSizeMax}{Maximum point size used for QC and Gene Expression plots
default is 5}
}
\value{
A ggplot spatial transcriptomics plot
}
\description{
This function overlays information from a Seurat object or 
SingleCellExperiment object containing barcodes  onto a H & E image. 
There are 4 plots available showing a) the number of
genes detected per spot, b) the number of reads detected per spot,
c) clustering results, d) the gene expression of a selected gene.
}
\examples{

pathToTenXOuts <- file.path(system.file(package = "Spaniel"), "extdata/outs")
sceObj <- createVisiumSCE(tenXDir=pathToTenXOuts, 
                       resolution="Low") 
filter <- sceObj$detected > 0             
spanielPlot(object = sceObj, 
plotType = "NoGenes", 
showFilter = filter, 
techType = "Visium", 
ptSizeMax = 3)
}
