% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialQCPlots.R
\name{plotMetricHist}
\alias{plotMetricHist}
\title{plotMetricHist}
\usage{
plotMetricHist(
  spe,
  metric,
  fillColor = "#c0c8cf",
  useFences = NULL,
  fencesColors = c(lower = "purple4", higher = "tomato"),
  bins = 30,
  binWidth = NULL
)
}
\arguments{
\item{spe}{A `SpatialExperiment` object containing spatial transcriptomics
data.}

\item{metric}{A character string specifying the name of the metric
(column in `colData(spe)`) to plot.}

\item{fillColor}{A character string specifying the fill color of the
histogram bars. (Default is `"#69b3a2"`)}

\item{useFences}{A character string specifying the name of the column in
`colData(spe)` that contains the fence thresholds (typically from an outlier
filter). If `NULL`, no fences will be plotted. (Default is `NULL`)}

\item{fencesColors}{A named character vector specifying the colors to use
for the lower and higher fences. The names should be `"lower"` and `"higher"`
. (Default is `c("lower"="purple4", "higher"="tomato")`)}

\item{bins}{An integer specifying the number of bins to use in the histogram.
(Default is `30`)}

\item{binWidth}{A numeric value specifying the width of the bins. If `NULL`,
the bin width will be automatically determined based on the `bins` parameter.
(Default is `NULL`)}
}
\value{
A `ggplot` object representing the histogram of the specified metric.
}
\description{
Plot a Histogram for a Given Metric in a SpatialExperiment
Object

This function generates a histogram for a specified metric in a
`SpatialExperiment` object.
}
\examples{
example(readCosmxSPE)
g <- plotMetricHist(spe, metric="Mean.DAPI")
print(g)
}
