% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{get_spatial_features}
\alias{get_spatial_features}
\title{Load spatial features}
\usage{
get_spatial_features(filePath, method = NULL, featureNames = ".")
}
\arguments{
\item{filePath}{A string path to the location of the file containing the
spatial features.}

\item{method}{A string specifying the type of object to obtain spatial
feature from. Default NULL, where the method is inferred based on object
type. Other methods are: "CoGAPS", "Seurat", or "BayesTME".}

\item{featureNames}{An array of strings specifying the column names
corresponding to the feature names or a regex string. In the case of Seurat,
all metadata columns with "_Feature" suffix are selected.}
}
\value{
a matrix of spatial features with barcodes associated
with individual coordinates
}
\description{
This function loads spatial features from a file containing
spatial features
}
\examples{
library(SpaceMarkers)
#CoGAPS data filePath
filePath <- system.file("extdata","CoGAPS_result.rds", 
package = "SpaceMarkers",mustWork = TRUE)
spFeatures <- get_spatial_features(filePath, method = "CoGAPS")
head(spFeatures)

}
