% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rebuildIndices.R
\name{rebuildIndex}
\alias{rebuildIndex}
\title{Rebuild the index}
\usage{
rebuildIndex(trained, num.threads = 1)
}
\arguments{
\item{trained}{List containing the output of \code{\link{trainSingleR}},
possibly after some operations that invalidate the indices.}

\item{num.threads}{Integer specifying the number of threads to use for training.}
}
\value{
\code{trained} is returned with valid indices.
If it already had valid indices, this function is a no-op.
}
\description{
Rebuild the index (or indices), typically after restarting the R session.
This is because the indices are held in external memory and are not serialized correctly by R.
}
\examples{
# Making up the training set.
ref <- .mockRefData()
ref <- scrapper::normalizeRnaCounts.se(ref)
trained <- trainSingleR(ref, ref$label)
trained$built # a valid address

# Saving and reloading the index.
tmp <- tempfile(fileext=".rds")
saveRDS(trained, file=tmp)
reloaded <- readRDS(tmp)
reloaded$built # not valid anymore

rebuilt <- rebuildIndex(reloaded)
rebuilt$built # back to validity

}
\author{
Aaron Lun
}
