% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCSRNoNet-class.R
\name{SCSRNoNet}
\alias{SCSRNoNet}
\title{Prepare a SCSRNoNet object from expression data}
\usage{
SCSRNoNet(
  counts,
  populations,
  normalize = TRUE,
  symbol.col = NULL,
  min.count = 1,
  prop = 0.1,
  method = c("UQ", "TC"),
  log.transformed = FALSE,
  min.LR.found = 80,
  species = "hsapiens",
  conversion.dict = NULL,
  UQ.pc = 0.95
)
}
\arguments{
\item{counts}{A table or matrix of read counts.}

\item{populations}{A vector indicating to which cell population
each individual cell belongs to.}

\item{normalize}{A logical indicating whether \code{counts} should be
normalized according to \code{method} or if it was normalized beforehand.}

\item{symbol.col}{The index of the column containing the gene symbols in case
those are not the row names of \code{counts} already.}

\item{min.count}{The minimum read count of a gene to be considered expressed
in a sample.}

\item{prop}{The minimum proportion of samples where a gene must be
expressed higher than \code{min.count} to keep that gene.}

\item{method}{The normalization method ('UQ' for upper quartile or 'TC'
for total count). If \code{normalize==FALSE}, then method must be
used to document the name of the normalization method applied by the user.}

\item{log.transformed}{A logical indicating whether expression data were
already log2-transformed.}

\item{min.LR.found}{The minimum number of ligands or receptors found in
\code{count} row names after eliminating the rows containing too many
zeros according to \code{min.count} and \code{prop}.}

\item{species}{Data were obtained for this organism.}

\item{conversion.dict}{Correspondence table of HUGO gene symbols
human/nonhuman. Not used unless the organism is different from human.}

\item{UQ.pc}{Percentile for upper-quartile normalization, number
between 0 and 1 (in case the default 0.95 is not
appropriate).}
}
\value{
A SCSRNoNet object with empty interactions.
}
\description{
Take a matrix or data frame containing single-cell RNA sequencing
or proteomics data and return a SCSRNoNet
object ready for subsequent cellular network inference.
Normally, SCSRNoNet objects
are not instantiated directly, but through this function.
}
\details{
The \code{counts} matrix or table should be provided with expression
  levels of protein coding genes in each samples (column) and
  \code{rownames(counts)} set to HUGO official gene symbols. 
  For commodity, it is also possible to provide \code{counts} with the
  gene symbols stored in one of its columns. This column must be specified
  with \code{symbol.col}. In such a case, \code{prepareDataset} will extract
  this column and use it to set the row names. Because row names must be
  unique, \code{prepareDataset} will eliminate rows with duplicated gene
  symbols by keeping the rows with maximum average expression. Gene symbol
  duplication may occur in protein coding genes after genome alignment
  due to errors in genome feature annotation files (GTF/GFF), where a handful
  of deprecated gene annotations might remain, or
  some genes are not given their fully specific symbols. If your read count
  extraction pipeline does not take care of this phenomenon, the maximum mean
  expression selection strategy implemented here should solve this difficulty
  for the sake of inferring ligand-receptor interactions.

  If \code{normalize} is \code{TRUE} then normalization is performed
  according to \code{method}. If those two simple methods are not satisfying,
  then it is possible to provide a pre-normalized matrix setting
  \code{normalize} to \code{FALSE}. In such a case, the parameter
  \code{method} must be used to document the name of the normalization
  algorithm used.

  In case proteomic data are provided, \code{min.count} must be
  understood as its equivalent with respect to those data.
}
\examples{
print("SCSRNoNet")
data(example_dataset, package = "SingleCellSignalR")
mat <- log1p(data.matrix(example_dataset[, -1])) / log(2)
rownames(mat) <- example_dataset[[1]]
rme <- rowMeans(mat)
mmat <- mat[rme > 0.05, ]
d <- dist(t(mmat))
h <- hclust(d, method = "ward.D")
pop <- paste0("pop_", cutree(h, 5))
scsrnn <- SCSRNoNet(mat,
    normalize = FALSE, method = "log-only",
    log.transformed = TRUE, populations = pop
)

}
