% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.files.R
\name{GetMarkerNames}
\alias{GetMarkerNames}
\title{Takes in an example file as input and returns all marker names}
\usage{
GetMarkerNames(file)
}
\arguments{
\item{file}{the fcs file of interest}
}
\value{
the list of markers of interest. This is to be written as a csv
}
\description{
This is a quick way to get a list of preferred marker names.
This outputs a csv file containing all markers in the dataset in the name
format that will be recognized by downstream functions. You manually
alter this list to remove and/or categorize the said markers. The file
can then be read in (stringsAsFactors = FALSE) to give you the marker
list of interest. In particular, name the top of the column as "markers" if
you're just altering the list. If you're doing to divide it into static
and functional markers, produce two columns, naming them respectively.
}
\examples{
file <- system.file("extdata", "Bendall_et_al_Cell_Sample_C_basal.fcs",
    package = "Sconify")
GetMarkerNames(file)
}
