% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-globalbv.R
\name{runGLOBALBV}
\alias{runGLOBALBV}
\alias{runGLOBALBV,SingleCellExperiment-method}
\alias{runGLOBALBV,SingleCellExperiment}
\alias{runGLOBALBV,SVPExperiment-method}
\alias{runGLOBALBV,SVPExperiment}
\title{Global Bivariate analysis for spatial autocorrelation}
\usage{
runGLOBALBV(
  data,
  features1 = NULL,
  features2 = NULL,
  assay.type = "logcounts",
  sample_id = "all",
  method = c("lee"),
  weight = NULL,
  weight.method = c("voronoi", "knn", "none"),
  reduction.used = NULL,
  group.by = NULL,
  permutation = 100,
  alternative = c("two.sided", "greater", "less"),
  add.pvalue = FALSE,
  random.seed = 1024,
  action = c("get", "only"),
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  gsvaexp.features = NULL,
  across.gsvaexp = TRUE,
  ...
)

\S4method{runGLOBALBV}{SingleCellExperiment}(
  data,
  features1 = NULL,
  features2 = NULL,
  assay.type = "logcounts",
  sample_id = "all",
  method = c("lee"),
  weight = NULL,
  weight.method = c("voronoi", "knn", "none"),
  reduction.used = NULL,
  group.by = NULL,
  permutation = 100,
  alternative = c("two.sided", "greater", "less"),
  add.pvalue = FALSE,
  random.seed = 1024,
  action = c("get", "only"),
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  gsvaexp.features = NULL,
  across.gsvaexp = TRUE,
  ...
)

\S4method{runGLOBALBV}{SVPExperiment}(
  data,
  features1 = NULL,
  features2 = NULL,
  assay.type = "logcounts",
  sample_id = "all",
  method = c("lee"),
  weight = NULL,
  weight.method = c("voronoi", "knn", "none"),
  reduction.used = NULL,
  group.by = NULL,
  permutation = 100,
  alternative = c("two.sided", "greater", "less"),
  add.pvalue = FALSE,
  random.seed = 1024,
  action = c("get", "only"),
  verbose = TRUE,
  gsvaexp = NULL,
  gsvaexp.assay.type = NULL,
  gsvaexp.features = NULL,
  across.gsvaexp = TRUE,
  ...
)
}
\arguments{
\item{data}{a \linkS4class{SingleCellExperiment} object with contains \code{UMAP} or \code{TSNE},
or a \linkS4class{SpatialExperiment} object, or a \linkS4class{SVPExperiment} object with specified
\code{gsvaexp} argument.}

\item{features1}{the features name data object (only supporting character), default is NULL,
see also \code{features2} parameter.}

\item{features2}{character, if \code{features1} is not NULL, and \code{features2} is NULL,
only the \code{features1} are analyzed, if \code{features1} is NULL, and \code{features2} is
is not NULL, the \code{features2} are analyzed, if \code{features2} is also NULL, all of features in the
\code{data} object will be analyzed. If \code{features2} and \code{features1} are not NULL, the bivariate
spatial autocorrelation analysis will be performed between the \code{features1} and \code{features2}.
default is \code{NULL}.}

\item{assay.type}{which expressed data to be pulled to run, default is \code{logcounts}.}

\item{sample_id}{character the sample(s) in the \linkS4class{SpatialExperiment} object whose cells/spots to use.
Can be \code{all} to compute metric for all samples; the metric is computed separately for each sample.
default is \code{"all"}.}

\item{method}{character now only the \code{'lee'}, default is \code{'lee'}.}

\item{weight}{object, which can be \code{nb}, \code{listw} or \code{Graph} object, default is NULL,
meaning the spatial neighbours weights will be calculated using the \code{weight.method}.
if the \code{data} contains multiple samples, and the \code{sample_id} is specified, it should be
provided as a list object with names (using \code{sample_id}).}

\item{weight.method}{character the method to build the spatial neighbours weights, default
is \code{voronoi} (Voronoi tessellation). Other method, which requires coord matrix as input and returns
\code{nb}, \code{listw} or \code{Graph} object, also is available, such as \code{"knearneigh"},
\code{'dnearneigh'}, \code{"gabrielneigh"}, \code{"relativeneigh"}, which are from \code{spdep} package.
default is \code{knn}, if it is \code{"none"}, meaning the distance weight of each spot is used to
the weight.}

\item{reduction.used}{character used as spatial coordinates to calculate the neighbours weights,
default is \code{NULL}, the result of reduction can be specified, such as \code{UMAP}, \code{TSNE}, \code{PCA}.
If it is specified, the weight neighbours matrix will be calculated using the result of specified reduction.}

\item{group.by}{character a specified category column names (for example the cluster column name) of
\code{colData(data)}. Or a vector of length equal to \code{ncol(x)}, specifying the group to which each cell
is assigned. If it was specified, the adjacency weighted matrix will be built based on the principle that
spots or cells in the same category are adjacent, default is NULL.}

\item{permutation}{integer the permutation number to test, default is 100L, if permutation is smaller than 10
or NULL, which will use mantel test to calculate the pvalue.}

\item{alternative}{a character string specifying the alternative hypothesis, which only work with
\code{add.pvalue = TRUE}, default is \code{two.sided}.}

\item{add.pvalue}{logical whether calculate the pvalue, which is calculated with permutation test. So it might
be slow, default is \code{FALSE}, which the pvalue of result will be NULL.}

\item{random.seed}{numeric random seed number to repeatability, default is 1024.}

\item{action}{character, which should be one of \code{'only'} and \code{'get'}, default is \code{"only"}.
This will return a long tidy table (when the sample number of \code{data} is one) or a \code{SimpleList} which
contains long tidy table for each sample. When \code{action="get"}, it will return a list contained global bivariate
spatial autocorrelation and pvalue (when \code{add.pvalue=TRUE}), or a \code{SimpleList} which contains a list
global bivariate spatial result for each sample (when the sample number of \code{data} is larger than one).}

\item{verbose}{logical whether print the help information, default is TRUE.}

\item{gsvaexp}{character the one character from the name of \code{gsvaExpNames(data)}, default is NULL. If \code{data}
is \linkS4class{SVPExperiment}, and the parameter is specified simultaneously. the \code{features} (Usually genes)
from the displayed class, and \code{gsvaexp.features} from name in \code{rownames(gsvaExp(data, gsvaexp))} will be
performed the analysis.}

\item{gsvaexp.assay.type}{character the assay name in the \code{assays(gsvaExp(data, gsvaexp))}, default is NULL,
which works with \code{gsvaexp} parameter.}

\item{gsvaexp.features}{character the name from the \code{rownames(gsvaExp(data, gsvaexp))}. If \code{gsvaexp} is
specified and \code{data} is \linkS4class{SVPExperiment}, it should be provided. Default is NULL.}

\item{across.gsvaexp}{logical whether only calculate the relationship of features between the multiple \code{gsvaExps}
not the internal features of gsvaExp. For example, \code{'a'} and \code{'b'} features are from the \code{'AB'} \code{gsvaExp},
\code{'c'} and \code{'d'} features are from the \code{'CD'} \code{gsvaExp}. When \code{across.gsvaexp=TRUE} and
\code{gsvaexp.features = c('a', 'b', 'c', 'd')} and \code{gsvaexp = c('AB', 'CD')}, Only the relationship of
\code{a} and \code{c}, \code{a} and \code{d}, \code{b} and \code{c}, and \code{b} and \code{d} will be calculated.
default is TRUE.}

\item{...}{additional parameters the parameters which are from the weight.method function.}
}
\value{
SimpleList or long tidy table see also the help information of \code{action} argument.
}
\description{
This function is to explore the global bivariate relationship in the spatial space.
It efficiently reflects the extent to which bivariate associations are spatially grouped.
Put differently, it can be utilized to quantify the bivariate spatial dependency. See
also the references.
}
\examples{
data(hpda_spe_cell_dec)
rownames(hpda_spe_cell_dec) |> head()
res1 <- runGLOBALBV(hpda_spe_cell_dec, 
                    features1 = "Ductal APOL1 high-hypoxic", 
                    features2 = c('Cancer clone A', "Cancer clone B"), 
                    assay.type = 'affi.score', 
                    action='only'
        )
res1
res2 <- runGLOBALBV(hpda_spe_cell_dec, 
                    features1 = c("Acinar cells", 
                                  "Ductal APOL1 high-hypoxic", 
                                  "Cancer clone A",
                                  "Cancer clone B"), 
                    assay.type = 1, 
                    action = 'get'
        )
res2
# when add.pvalue = TRUE and permutation <= 10 or NULL, the pvalue will be
# calculated using mantel test.
res3 <- runGLOBALBV(hpda_spe_cell_dec, features1 = rownames(hpda_spe_cell_dec), 
                    assay.type = 1, action='get', add.pvalue=TRUE, permutation=NULL)
res3 |> as_tbl_df(diag=FALSE) 
}
\references{
\enumerate{
\item Lee, SI. Developing a bivariate spatial association measure: An integration of Pearson's r and Moran's I .
J Geograph Syst 3, 369–385 (2001). https://doi.org/10.1007/s101090100064
\item Lee, SI. A Generalized Significance Testing Method for Global Measures of Spatial Association:
An Extension of the Mantel Test. Environment and Planning A: Economy and Space, 36(9), 1687-1703.
https://doi.org/10.1068/a34143.
}
}
\seealso{
\code{\link{runDetectSVG}} and \code{\link{runKldSVG}} to identify the spatial variable features.
\code{\link{runLISA}} to explore the spatial hotspots.
}
\author{
Shuangbin Xu
}
