% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configExperiment.R
\name{configExperiment}
\alias{configExperiment}
\title{Configure experiment}
\usage{
configExperiment(batch.config, group.config, tot.samples, batch, group)
}
\arguments{
\item{batch.config}{a numerical vector for the marginal fraction of samples in each batch. 
The number of batches to be simulated is equal to the size of the vector.
All values must sum to 1.}

\item{group.config}{a numerical vector for the marginal fraction of samples in each group.
The number of groups to be simulated is equal to the size of the vector. All values must sum to 1.}

\item{tot.samples}{total number of samples to be simulated.}

\item{batch, group}{batch and grouping vectors}
}
\value{
a list object contating the number of groups and batches to be simukated, 
and the experiment configurartion
}
\description{
Configure experiment
}
\examples{
batch = sample(LETTERS[1:3], 20, replace = TRUE)
group = sample(1:3, 20, replace = TRUE)
#---- a design with a total of 10 samples/cells from 1 batch and 1 group
configExperiment(batch.config=1, group.config=1, tot.samples=10, 
batch = batch, group = group)

#---- a design with a total of 20 samples/cells from 1 group and 2 batchs with 
# batch 1 has 15 samples/cells and batch 2 has 5
configExperiment(batch.config = c(15/20, 5/20), group.config = 1, 
tot.samples = 20, batch = batch, group = group)

#---- a design with a total of 20 samples/cells from 1 batch and 2 groups with 
# group 1 has 10 samples/cells and batch 2 has 10
configExperiment(batch.config=1, group.config=c(0.5, 0.5), tot.samples=20, 
batch = batch, group = group)

#---- a design with a total of 30 samples/cells from 2 groups with group 1 has 15 samples 
# and group 2 has 15, and  three batchs with batch 1,2, and 3 have 5, 10, and 15 samples/cells, 
# respectively.
configExperiment(batch.config = c(5/30, 10/30, 15/30), group.config = c(0.5, 0.5),
 tot.samples = 30, batch = batch, group = group)
}
