\name{sim.plot.pvals.on.genome}

\alias{sim.plot.pvals.on.genome}

\title{Plot the P-values in whole genome overview}

\description{
	Generates a plot of the analyzed dependent data probe positions and their significance on all chromosomes.
}

\usage{
sim.plot.pvals.on.genome(input.regions = "all chrs", 
  					     significance = c(0.05, 0.20), 
						 adjust.method = "BY", 
						 method = c("full", "smooth", "window", "overlap"),		
						 run.name = "analysis_results",
						 pdf = TRUE, 
						 main = "Significantly associated features",
						 ylab = "Chromosomes",						 
						 ann=par("ann"),
						 ...)
}

\arguments{
 \item{input.regions}{\code{vector} indicating the dependent regions to be analyzed. Can be defined in four ways:
  	      \code{1) predefined input region: } insert a predefined input region, choices are: 
  	      \dQuote{all chrs}, 
  	      \dQuote{all chrs auto}, 
  	      \dQuote{all arms}, 
  	      \dQuote{all arms auto} 
  	      In the predefined regions \dQuote{all arms} and \dQuote{all arms auto} the arms 13p, 14p, 15p, 21p and 22p 
  	      are left out, because in most studies there are no or few probes in these regions. 
  	      To include them, just make your own vector of arms. 
  	      \code{2) whole chromosome(s): } insert a single chromosome or a list of chromosomes as a 
  	      \code{vector:} 
  	      \code{c(1, 2, 3)}. 
  	      \code{3) chromosome arms: } insert a single chromosome arm  or a list of chromosome arms like 
  	      \code{c("1q", "2p", "2q")}.
  	      \code{4) subregions of a chromosome: } insert a chromosome number followed by the start and end position like 
  	      \code{"chr1:1-1000000"} 
  	      These regions can also be combined, e.g. \code{c("chr1:1-1000000","2q", 3)}.
  	      See \code{\link{integrated.analysis}} for more information.}  

 \item{significance}{Two values that categorize the P-values on the selected chromosomes. 
                     These margins are indicated by different colors shown in the legend. 
                     These values can be defined, e.g. \code{pval.sig = c(0.3, 0.075)}}

  \item{adjust.method}{Method used to adjust the P-values for multiple testing. see \link[stats:p.adjust]{p.adjust}
                       Default is \dQuote{BY} recommended when copy number is used as dependent data. 
                       See \link{SIM} for more information about adjusting P-values.}

  \item{method}{this must be the either full, window, overlap or smooth but the data should generated by the 
                same method in \code{integrated.analysis}.}

  \item{pdf}{Boolean. Indicate whether to generate a pdf of the plots in the current working directory or not.} 

  \item{run.name}{This must be the same a given to \code{integrated.analysis}}
  
  \item{main}{the usual graphical parameter for the caption of the plot.}  
  \item{ylab}{the usual graphical parameter for the y-axis label of the plot.}
  \item{ann}{the usual graphical parameter for annotation of the plot.}	

  \item{...}{Arguments to be passed to \code{pdf} when \code{pdf = TRUE}, see Details.}
}

\details{
	Grey vertical lines indicate unsignificant probes on top the significant ones are plotted. A purple
dot indicates the centromere and a organe line the input region.

Sometimes it is useful to make the genome-plot as A4 landscape-format, add the following parameters to the 
\code{sim.plot.pvals.on.genome(..., paper='a4r', width=0, height=0)}
}

\value{
	No values are returned. The results are stored in the folder \dQuote{pvalue.plots} in directory \code{run.name} as pdf.
}

\author{Marten Boetzer, Melle Sieswerda, Renee X. de Menezes \email{R.X.Menezes@lumc.nl}}

\seealso{
\link{SIM}, 
\link{sim.plot.zscore.heatmap}, 
\link{sim.plot.pvals.on.region}
}

\examples{
#first run example(assemble.data)
#and example(integrated.analysis)
#plot the p-values along the genome
sim.plot.pvals.on.genome(input.regions="8q", 
		                 significance=c(0.05, 0.005), 
						 adjust.method="BY", 
						 method="full", 
						 pdf=FALSE, 
						 run.name="chr8q")
}
\keyword{hplot}

